<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('subscription_plans', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('name_ar');
            $table->text('description')->nullable();
            $table->text('description_ar')->nullable();
            $table->enum('type', ['business', 'user']);
            $table->enum('duration_type', ['monthly', 'quarterly', 'yearly']);
//            duration_days
            $table->integer('duration_days');
//            max_photos_per_venue
            $table->integer('max_photos_per_venue')->nullable();
//            analytics_access
            $table->boolean('analytics_access')->default(false);
//            'priority_support
            $table->boolean('priority_support')->default(false);
//            featured_listing
            $table->boolean('featured_listing')->default(false);
//            custom_branding
            $table->boolean('custom_branding')->default(false);
//            api_access
            $table->boolean('api_access')->default(false);
            $table->decimal('price', 10, 2);
            $table->string('currency', 3)->default('AED');
            $table->json('features')->nullable();
            $table->integer('max_venues')->nullable();
            $table->integer('max_offers')->nullable();
            $table->integer('max_staff')->nullable();
            $table->boolean('is_popular')->default(false);
            $table->boolean('is_active')->default(true);
            $table->integer('sort_order')->default(0);
            $table->timestamps();
            $table->softDeletes();

            $table->index(['type', 'is_active']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('subscription_plans');
    }
};
