<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('faqs', function (Blueprint $table) {
            $table->id();
            $table->string('question');
            $table->string('question_ar')->nullable();
            $table->text('answer');
            $table->text('answer_ar')->nullable();
            $table->enum('category', ['general', 'account', 'subscription', 'offers', 'business', 'payment', 'privacy','technical'])->default('general');
            $table->integer('order')->default(0);
            $table->boolean('is_active')->default(true);
            $table->integer('views')->default(0);
            $table->integer('helpful_count')->default(0);
            $table->timestamps();

            $table->index(['category', 'is_active', 'order']);
        });

        // Insert default FAQs
        $faqs = [
            // General
            [
                'question' => 'What is Privasee?',
                'question_ar' => 'ما هو بريفاسي؟',
                'answer' => 'Privasee is a premium lifestyle platform connecting users with exclusive offers from top venues in UAE. Discover dining, entertainment, wellness, and more with personalized deals.',
                'answer_ar' => 'بريفاسي هي منصة حياة متميزة تربط المستخدمين بعروض حصرية من أفضل الأماكن في الإمارات. اكتشف المطاعم والترفيه والعافية والمزيد مع صفقات مخصصة.',
                'category' => 'general',
                'order' => 1,
            ],
            [
                'question' => 'How does Privasee work?',
                'question_ar' => 'كيف يعمل بريفاسي؟',
                'answer' => 'Simply download our app, choose your subscription plan, and start browsing exclusive offers from premium venues. Redeem offers instantly using QR codes at participating venues.',
                'answer_ar' => 'ببساطة قم بتنزيل تطبيقنا، اختر خطة اشتراكك، وابدأ في تصفح العروض الحصرية من الأماكن المتميزة. استرد العروض فوراً باستخدام رموز QR في الأماكن المشاركة.',
                'category' => 'general',
                'order' => 2,
            ],
            [
                'question' => 'Which cities do you operate in?',
                'question_ar' => 'في أي مدن تعملون؟',
                'answer' => 'Currently we operate in Dubai, Abu Dhabi, and Sharjah, with plans to expand to other UAE cities and GCC countries soon.',
                'answer_ar' => 'حالياً نعمل في دبي وأبو ظبي والشارقة، مع خطط للتوسع إلى مدن أخرى في الإمارات ودول مجلس التعاون الخليجي قريباً.',
                'category' => 'general',
                'order' => 3,
            ],
            // Account
            [
                'question' => 'How do I create an account?',
                'question_ar' => 'كيف أقوم بإنشاء حساب؟',
                'answer' => 'Download the Privasee app and sign up using your email, phone number, or social media accounts (Google/Facebook). Verify your contact and start exploring offers.',
                'answer_ar' => 'قم بتنزيل تطبيق بريفاسي وقم بالتسجيل باستخدام بريدك الإلكتروني أو رقم هاتفك أو حسابات وسائل التواصل الاجتماعي (جوجل/فيسبوك). تحقق من جهة اتصالك وابدأ في استكشاف العروض.',
                'category' => 'account',
                'order' => 1,
            ],
            [
                'question' => 'Can I use multiple devices?',
                'question_ar' => 'هل يمكنني استخدام أجهزة متعددة؟',
                'answer' => 'Yes, you can access your account from multiple devices. Your subscription and saved offers will sync automatically across all devices.',
                'answer_ar' => 'نعم، يمكنك الوصول إلى حسابك من أجهزة متعددة. ستتم مزامنة اشتراكك والعروض المحفوظة تلقائياً عبر جميع الأجهزة.',
                'category' => 'account',
                'order' => 2,
            ],
            // Subscription
            [
                'question' => 'What subscription plans are available?',
                'question_ar' => 'ما هي خطط الاشتراك المتاحة؟',
                'answer' => 'We offer three plans: Free (basic offers), Premium (special offers + more venues), and VIP (exclusive offers + all features). Choose the plan that suits your lifestyle.',
                'answer_ar' => 'نقدم ثلاث خطط: مجاني (عروض أساسية)، بريميوم (عروض خاصة + المزيد من الأماكن)، وVIP (عروض حصرية + جميع الميزات). اختر الخطة التي تناسب أسلوب حياتك.',
                'category' => 'subscription',
                'order' => 1,
            ],
            [
                'question' => 'Can I cancel my subscription?',
                'question_ar' => 'هل يمكنني إلغاء اشتراكي؟',
                'answer' => 'Yes, you can cancel anytime from your account settings. Your subscription will remain active until the end of the current billing period.',
                'answer_ar' => 'نعم، يمكنك الإلغاء في أي وقت من إعدادات حسابك. سيبقى اشتراكك نشطاً حتى نهاية فترة الفوترة الحالية.',
                'category' => 'subscription',
                'order' => 2,
            ],
            // Offers
            [
                'question' => 'How do I redeem an offer?',
                'question_ar' => 'كيف أسترد عرضاً؟',
                'answer' => 'Select the offer you want, tap "Redeem", and show the QR code to the venue staff. They will scan it to apply your discount or special offer.',
                'answer_ar' => 'اختر العرض الذي تريده، اضغط على "استرداد"، وأظهر رمز QR لموظفي المكان. سيقومون بمسحه لتطبيق خصمك أو عرضك الخاص.',
                'category' => 'offers',
                'order' => 1,
            ],
            [
                'question' => 'Can I use multiple offers at once?',
                'question_ar' => 'هل يمكنني استخدام عروض متعددة في وقت واحد؟',
                'answer' => 'Generally, one offer can be redeemed per visit. Check the offer terms for specific restrictions. Some venues may allow combining certain offers.',
                'answer_ar' => 'بشكل عام، يمكن استرداد عرض واحد لكل زيارة. تحقق من شروط العرض للقيود المحددة. قد تسمح بعض الأماكن بدمج عروض معينة.',
                'category' => 'offers',
                'order' => 2,
            ],
            // Business
            [
                'question' => 'How can I list my business?',
                'question_ar' => 'كيف يمكنني إدراج عملي؟',
                'answer' => 'Visit our business portal, register your business, and submit your venue details. Our team will verify your business and activate your account within 24-48 hours.',
                'answer_ar' => 'قم بزيارة بوابة الأعمال الخاصة بنا، سجل عملك، وقدم تفاصيل مكانك. سيقوم فريقنا بالتحقق من عملك وتفعيل حسابك خلال 24-48 ساعة.',
                'category' => 'business',
                'order' => 1,
            ],
            [
                'question' => 'What are the fees for businesses?',
                'question_ar' => 'ما هي الرسوم للشركات؟',
                'answer' => 'We offer flexible subscription plans for businesses starting from AED 299/month. This includes venue listing, offer management, analytics, and marketing tools.',
                'answer_ar' => 'نقدم خطط اشتراك مرنة للشركات تبدأ من 299 درهم إماراتي شهرياً. يشمل ذلك قائمة الأماكن وإدارة العروض والتحليلات وأدوات التسويق.',
                'category' => 'business',
                'order' => 2,
            ],
            // Payment
            [
                'question' => 'What payment methods do you accept?',
                'question_ar' => 'ما هي طرق الدفع التي تقبلونها؟',
                'answer' => 'We accept all major credit/debit cards (Visa, Mastercard, Amex), PayPal, and Apple Pay. All transactions are secure and encrypted.',
                'answer_ar' => 'نقبل جميع بطاقات الائتمان/الخصم الرئيسية (فيزا، ماستركارد، أمريكان إكسبريس)، PayPal، وApple Pay. جميع المعاملات آمنة ومشفرة.',
                'category' => 'payment',
                'order' => 1,
            ],
            // Privacy
            [
                'question' => 'How do you protect my data?',
                'question_ar' => 'كيف تحمون بياناتي؟',
                'answer' => 'We use industry-standard encryption and security measures. Your data is stored securely and never shared with third parties without your consent. We comply with GDPR and local data protection laws.',
                'answer_ar' => 'نستخدم التشفير ومعايير الأمان الصناعية. يتم تخزين بياناتك بشكل آمن ولا يتم مشاركتها مع أطراف ثالثة بدون موافقتك. نحن نلتزم بقوانين GDPR وقوانين حماية البيانات المحلية.',
                'category' => 'privacy',
                'order' => 1,
            ],
        ];

        foreach ($faqs as $faq) {
            $faq['created_at'] = now();
            $faq['updated_at'] = now();
            $faq['is_active'] = true;
            DB::table('faqs')->insert($faq);
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('faqs');
    }
};
