<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('marketing_campaign_analytics', function (Blueprint $table) {

            $table->id();

            // Basic campaign info
            $table->string('campaign_name');
            $table->enum('campaign_type', ['email', 'push', 'sms'])->default('email');
            $table->string('subject')->nullable();
            $table->longText('message')->nullable();

            // Target audience
            $table->string('target_audience')->nullable();  // all, active, businesses, subscribers

            // Schedule
            $table->dateTime('scheduled_at')->nullable();

            // Delivery metrics
            $table->unsignedBigInteger('sent_count')->default(0);
            $table->unsignedBigInteger('delivered_count')->default(0);
            $table->unsignedBigInteger('bounce_count')->default(0);

            // Engagement metrics
            $table->unsignedBigInteger('opened_count')->default(0);
            $table->unsignedBigInteger('clicked_count')->default(0);
            $table->unsignedBigInteger('unsubscribed_count')->default(0);
            $table->unsignedBigInteger('spam_report_count')->default(0);

            // Status
            $table->enum('status', [
                'draft',
                'scheduled',
                'active',
                'completed'
            ])->default('draft');

            // Relations (if you link to a campaigns table)
            $table->unsignedBigInteger('campaign_id')->nullable()->index();

            // Optional metadata
            $table->json('meta')->nullable(); // extra JSON for custom fields

            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('marketing_campaign_analytics');
    }
};
