<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Category;
use Illuminate\Support\Str;

class CategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $categories = [
            [
                'name' => 'Food & Dining',
                'name_ar' => 'الطعام والشراب',
                'slug' => 'food-dining',
                'icon' => 'restaurant',
                'description' => 'Restaurants, cafes, bakeries, and food delivery services',
                'description_ar' => 'المطاعم والمقاهي والمخابز وخدمات توصيل الطعام',
                               'is_active' => true,
            ],
            [
                'name' => 'Entertainment',
                'name_ar' => 'الترفيه',
                'slug' => 'entertainment',
                'icon' => 'theater-masks',
                'description' => 'Cinemas, theaters, gaming centers, and entertainment venues',
                'description_ar' => 'السينما والمسارح ومراكز الألعاب وأماكن الترفيه',
                               'is_active' => true,
            ],
            [
                'name' => 'Health & Fitness',
                'name_ar' => 'الصحة واللياقة',
                'slug' => 'health-fitness',
                'icon' => 'heart-pulse',
                'description' => 'Gyms, yoga studios, spas, and sports clubs',
                'description_ar' => 'الصالات الرياضية واستوديوهات اليوغا والمنتجعات الصحية والأندية الرياضية',
                               'is_active' => true,
            ],
            [
                'name' => 'Beauty & Wellness',
                'name_ar' => 'التجميل والعناية',
                'slug' => 'beauty-wellness',
                'icon' => 'sparkles',
                'description' => 'Salons, spas, nail studios, and beauty centers',
                'description_ar' => 'صالونات التجميل والمنتجعات الصحية واستوديوهات الأظافر ومراكز التجميل',
                               'is_active' => true,
            ],
            [
                'name' => 'Shopping',
                'name_ar' => 'التسوق',
                'slug' => 'shopping',
                'icon' => 'shopping-bag',
                'description' => 'Fashion, electronics, home decor, and retail stores',
                'description_ar' => 'الموضة والإلكترونيات وديكور المنزل ومتاجر التجزئة',
                               'is_active' => true,
            ],
            [
                'name' => 'Travel & Hotels',
                'name_ar' => 'السفر والفنادق',
                'slug' => 'travel-hotels',
                'icon' => 'airplane',
                'description' => 'Hotels, resorts, travel agencies, and tour operators',
                'description_ar' => 'الفنادق والمنتجعات ووكالات السفر ومنظمو الرحلات',
                               'is_active' => true,
            ],
            [
                'name' => 'Automotive',
                'name_ar' => 'السيارات',
                'slug' => 'automotive',
                'icon' => 'car',
                'description' => 'Car wash, service centers, auto parts, and car rental',
                'description_ar' => 'غسيل السيارات ومراكز الخدمة وقطع غيار السيارات وتأجير السيارات',
                               'is_active' => true,
            ],
            [
                'name' => 'Education',
                'name_ar' => 'التعليم',
                'slug' => 'education',
                'icon' => 'graduation-cap',
                'description' => 'Courses, tutoring, language schools, and training centers',
                'description_ar' => 'الدورات والدروس الخصوصية ومدارس اللغات ومراكز التدريب',
                               'is_active' => true,
            ],
            [
                'name' => 'Services',
                'name_ar' => 'الخدمات',
                'slug' => 'services',
                'icon' => 'tools',
                'description' => 'Cleaning, repair, photography, and event planning',
                'description_ar' => 'التنظيف والإصلاح والتصوير وتنظيم الفعاليات',
                               'is_active' => true,
            ],
            [
                'name' => 'Kids & Family',
                'name_ar' => 'الأطفال والعائلة',
                'slug' => 'kids-family',
                'icon' => 'users',
                'description' => 'Playgrounds, kids activities, family entertainment, and childcare',
                'description_ar' => 'ملاعب الأطفال وأنشطة الأطفال والترفيه العائلي ورعاية الأطفال',
                                'is_active' => true,
            ],
            [
                'name' => 'Pets',
                'name_ar' => 'الحيوانات الأليفة',
                'slug' => 'pets',
                'icon' => 'paw',
                'description' => 'Pet stores, grooming, veterinary clinics, and pet care',
                'description_ar' => 'متاجر الحيوانات الأليفة والعناية بالحيوانات والعيادات البيطرية',
                                'is_active' => true,
            ],
            [
                'name' => 'Home Services',
                'name_ar' => 'خدمات المنزل',
                'slug' => 'home-services',
                'icon' => 'home',
                'description' => 'Cleaning, maintenance, plumbing, electrical, and home improvement',
                'description_ar' => 'التنظيف والصيانة والسباكة والكهرباء وتحسين المنزل',
                                'is_active' => true,
            ],
            [
                'name' => 'Events & Venues',
                'name_ar' => 'الفعاليات والأماكن',
                'slug' => 'events-venues',
                'icon' => 'calendar-event',
                'description' => 'Event spaces, wedding venues, party planning, and catering',
                'description_ar' => 'أماكن الفعاليات وقاعات الأفراح وتنظيم الحفلات وخدمات الطعام',
                                'is_active' => true,
            ],
            [
                'name' => 'Sports & Recreation',
                'name_ar' => 'الرياضة والترفيه',
                'slug' => 'sports-recreation',
                'icon' => 'basketball',
                'description' => 'Sports facilities, recreational activities, and outdoor adventures',
                'description_ar' => 'المرافق الرياضية والأنشطة الترفيهية والمغامرات الخارجية',
                                'is_active' => true,
            ],
            [
                'name' => 'Professional Services',
                'name_ar' => 'الخدمات المهنية',
                'slug' => 'professional-services',
                'icon' => 'briefcase',
                'description' => 'Legal, accounting, consulting, and business services',
                'description_ar' => 'الخدمات القانونية والمحاسبية والاستشارية وخدمات الأعمال',
                                'is_active' => true,
            ],
        ];

        foreach ($categories as $category) {
            Category::create($category);
        }

        $this->command->info('Categories seeded successfully!');
        $this->command->info('Total categories created: ' . count($categories));
    }
}
