<?php

namespace Database\Seeders;

use App\Models\Faq;
use Illuminate\Database\Seeder;

class FaqSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $faqs = [
            // General
            [
                'category' => 'general',
                'question' => 'What is Privasee?',
                'question_ar' => 'ما هو بريفاسي؟',
                'answer' => 'Privasee is a premium lifestyle platform that connects you with exclusive offers and experiences from the best venues across UAE. Get access to special discounts, exclusive deals, and unique experiences.',
                'answer_ar' => 'بريفاسي هي منصة نمط حياة متميزة تربطك بعروض وتجارب حصرية من أفضل الأماكن في الإمارات. احصل على خصومات خاصة وصفقات حصرية وتجارب فريدة.',
                'order' => 1,
                'is_active' => true,
            ],
            [
                'category' => 'general',
                'question' => 'How does Privasee work?',
                'question_ar' => 'كيف يعمل بريفاسي؟',
                'answer' => 'Simply download the app, create an account, browse available offers from partner venues, and redeem them by showing your QR code or redemption code at the venue. It\'s that easy!',
                'answer_ar' => 'ببساطة قم بتنزيل التطبيق، وإنشاء حساب، وتصفح العروض المتاحة من الأماكن الشريكة، واستردادها عن طريق إظهار رمز الاستجابة السريعة أو رمز الاسترداد في المكان. الأمر بهذه السهولة!',
                'order' => 2,
                'is_active' => true,
            ],
            [
                'category' => 'general',
                'question' => 'Is Privasee available throughout UAE?',
                'question_ar' => 'هل بريفاسي متاح في جميع أنحاء الإمارات؟',
                'answer' => 'Yes! Privasee operates across all Emirates with partner venues in Dubai, Abu Dhabi, Sharjah, Ajman, Ras Al Khaimah, Fujairah, and Umm Al Quwain.',
                'answer_ar' => 'نعم! يعمل بريفاسي في جميع الإمارات مع أماكن شريكة في دبي وأبو ظبي والشارقة وعجمان ورأس الخيمة والفجيرة وأم القيوين.',
                'order' => 3,
                'is_active' => true,
            ],

            // Account
            [
                'category' => 'account',
                'question' => 'How do I create an account?',
                'question_ar' => 'كيف أقوم بإنشاء حساب؟',
                'answer' => 'Download the Privasee app, tap "Sign Up", enter your details (name, email, phone), verify your email or phone number, and you\'re ready to start exploring offers!',
                'answer_ar' => 'قم بتنزيل تطبيق بريفاسي، اضغط على "التسجيل"، أدخل تفاصيلك (الاسم، البريد الإلكتروني، الهاتف)، تحقق من بريدك الإلكتروني أو رقم هاتفك، وستكون جاهزًا لبدء استكشاف العروض!',
                'order' => 4,
                'is_active' => true,
            ],
            [
                'category' => 'account',
                'question' => 'Can I use my social media account to sign up?',
                'question_ar' => 'هل يمكنني استخدام حساب وسائل التواصل الاجتماعي للتسجيل؟',
                'answer' => 'Yes! You can sign up using your Google or Facebook account for quick and easy registration.',
                'answer_ar' => 'نعم! يمكنك التسجيل باستخدام حساب Google أو Facebook للتسجيل السريع والسهل.',
                'order' => 5,
                'is_active' => true,
            ],
            [
                'category' => 'account',
                'question' => 'I forgot my password. What should I do?',
                'question_ar' => 'نسيت كلمة المرور الخاصة بي. ماذا علي أن أفعل؟',
                'answer' => 'Tap "Forgot Password" on the login screen, enter your email address, and we\'ll send you a reset link. Follow the link to create a new password.',
                'answer_ar' => 'اضغط على "نسيت كلمة المرور" في شاشة تسجيل الدخول، أدخل عنوان بريدك الإلكتروني، وسنرسل لك رابط إعادة التعيين. اتبع الرابط لإنشاء كلمة مرور جديدة.',
                'order' => 6,
                'is_active' => true,
            ],
            [
                'category' => 'account',
                'question' => 'How do I delete my account?',
                'question_ar' => 'كيف يمكنني حذف حسابي؟',
                'answer' => 'Go to Settings > Account > Request Account Deletion. Submit your request and our team will process it within 7 business days. Note that this action is permanent.',
                'answer_ar' => 'انتقل إلى الإعدادات > الحساب > طلب حذف الحساب. قدم طلبك وسيقوم فريقنا بمعالجته خلال 7 أيام عمل. لاحظ أن هذا الإجراء دائم.',
                'order' => 7,
                'is_active' => true,
            ],

            // Subscriptions
            [
                'category' => 'subscription',
                'question' => 'What subscription plans are available?',
                'question_ar' => 'ما هي خطط الاشتراك المتاحة؟',
                'answer' => 'We offer three plans: Basic (regular offers), Premium (regular + special offers), and VIP (all offers including exclusive deals). Each plan gives you access to different tiers of offers.',
                'answer_ar' => 'نقدم ثلاث خطط: الأساسية (العروض العادية)، والمتميزة (العروض العادية + الخاصة)، وVIP (جميع العروض بما في ذلك الصفقات الحصرية). تمنحك كل خطة إمكانية الوصول إلى مستويات مختلفة من العروض.',
                'order' => 8,
                'is_active' => true,
            ],
            [
                'category' => 'subscription',
                'question' => 'How much does a subscription cost?',
                'question_ar' => 'كم تكلفة الاشتراك؟',
                'answer' => 'Pricing varies by plan. Check the app for current pricing in your region. We offer monthly and annual subscription options with discounts for longer commitments.',
                'answer_ar' => 'تختلف الأسعار حسب الخطة. تحقق من التطبيق للحصول على الأسعار الحالية في منطقتك. نحن نقدم خيارات الاشتراك الشهري والسنوي مع خصومات للالتزامات الأطول.',
                'order' => 9,
                'is_active' => true,
            ],
            [
                'category' => 'subscription',
                'question' => 'Can I cancel my subscription?',
                'question_ar' => 'هل يمكنني إلغاء اشتراكي؟',
                'answer' => 'Yes, you can cancel your subscription at any time. Go to Settings > Subscription > Cancel Subscription. Your access will continue until the end of your billing period.',
                'answer_ar' => 'نعم، يمكنك إلغاء اشتراكك في أي وقت. انتقل إلى الإعدادات > الاشتراك > إلغاء الاشتراك. سيستمر وصولك حتى نهاية فترة الفوترة الخاصة بك.',
                'order' => 10,
                'is_active' => true,
            ],

            // Offers & Redemptions
            [
                'category' => 'offers',
                'question' => 'How do I redeem an offer?',
                'question_ar' => 'كيف أقوم باسترداد عرض؟',
                'answer' => 'Browse offers in the app, select the one you want, tap "Redeem", and show the QR code or redemption code to staff at the venue. They will scan or enter the code to complete the redemption.',
                'answer_ar' => 'تصفح العروض في التطبيق، حدد العرض الذي تريده، اضغط على "استرداد"، وأظهر رمز الاستجابة السريعة أو رمز الاسترداد للموظفين في المكان. سيقومون بمسح أو إدخال الرمز لإكمال الاسترداد.',
                'order' => 11,
                'is_active' => true,
            ],
            [
                'category' => 'offers',
                'question' => 'Can I use multiple offers at the same venue?',
                'question_ar' => 'هل يمكنني استخدام عروض متعددة في نفس المكان؟',
                'answer' => 'This depends on the venue\'s terms and conditions. Some venues allow multiple offer redemptions while others limit it to one per visit. Check the offer details for specific restrictions.',
                'answer_ar' => 'يعتمد هذا على شروط وأحكام المكان. تسمح بعض الأماكن باسترداد عروض متعددة بينما يحدد البعض الآخر عرضًا واحدًا لكل زيارة. تحقق من تفاصيل العرض للقيود المحددة.',
                'order' => 12,
                'is_active' => true,
            ],
            [
                'category' => 'offers',
                'question' => 'What if the venue doesn\'t accept my redemption code?',
                'question_ar' => 'ماذا لو لم يقبل المكان رمز الاسترداد الخاص بي؟',
                'answer' => 'First, ensure you\'re within the offer\'s validity period and meet all terms. If issues persist, contact the venue directly or reach out to our support team through the app.',
                'answer_ar' => 'أولاً، تأكد من أنك ضمن فترة صلاحية العرض وتلبي جميع الشروط. إذا استمرت المشاكل، اتصل بالمكان مباشرة أو تواصل مع فريق الدعم الخاص بنا من خلال التطبيق.',
                'order' => 13,
                'is_active' => true,
            ],
            [
                'category' => 'offers',
                'question' => 'How long is my redemption code valid?',
                'question_ar' => 'ما هي مدة صلاحية رمز الاسترداد الخاص بي؟',
                'answer' => 'Once you redeem an offer, you typically have a limited time (usually same day) to use it at the venue. The exact validity period is shown when you redeem the offer.',
                'answer_ar' => 'بمجرد استرداد عرض، عادة ما يكون لديك وقت محدود (عادة نفس اليوم) لاستخدامه في المكان. يتم عرض فترة الصلاحية الدقيقة عند استرداد العرض.',
                'order' => 14,
                'is_active' => true,
            ],

            // Technical
            [
                'category' => 'technical',
                'question' => 'The app is not working properly. What should I do?',
                'question_ar' => 'التطبيق لا يعمل بشكل صحيح. ماذا علي أن أفعل؟',
                'answer' => 'Try these steps: 1) Check your internet connection, 2) Close and restart the app, 3) Update to the latest version, 4) Clear app cache. If problems persist, contact our support team.',
                'answer_ar' => 'جرب هذه الخطوات: 1) تحقق من اتصالك بالإنترنت، 2) أغلق التطبيق وأعد تشغيله، 3) قم بالتحديث إلى أحدث إصدار، 4) امسح ذاكرة التخزين المؤقت للتطبيق. إذا استمرت المشاكل، اتصل بفريق الدعم الخاص بنا.',
                'order' => 15,
                'is_active' => true,
            ],

            // Business
            [
                'category' => 'business',
                'question' => 'How can I register my business on Privasee?',
                'question_ar' => 'كيف يمكنني تسجيل عملي على بريفاسي؟',
                'answer' => 'Visit our business portal at business.privasee.com, click "Register", fill in your business details, upload required documents, and submit for verification. Our team will review and contact you within 48 hours.',
                'answer_ar' => 'قم بزيارة بوابة الأعمال الخاصة بنا على business.privasee.com، انقر على "تسجيل"، املأ تفاصيل عملك، قم بتحميل المستندات المطلوبة، وأرسل للتحقق. سيراجع فريقنا ويتصل بك خلال 48 ساعة.',
                'order' => 16,
                'is_active' => true,
            ],
            [
                'category' => 'business',
                'question' => 'What are the subscription plans for businesses?',
                'question_ar' => 'ما هي خطط الاشتراك للشركات؟',
                'answer' => 'We offer three business plans: Startup (1 venue, 10 offers), SME (3 venues, 30 offers), and Enterprise (10 venues, 100 offers). Each plan includes team management and analytics.',
                'answer_ar' => 'نقدم ثلاث خطط للأعمال: الشركات الناشئة (مكان واحد، 10 عروض)، والشركات الصغيرة والمتوسطة (3 أماكن، 30 عرضًا)، والمؤسسات (10 أماكن، 100 عرض). تتضمن كل خطة إدارة الفريق والتحليلات.',
                'order' => 17,
                'is_active' => true,
            ],

            // Privacy
            [
                'category' => 'privacy',
                'question' => 'How is my personal data protected?',
                'question_ar' => 'كيف يتم حماية بياناتي الشخصية؟',
                'answer' => 'We take data privacy seriously. Your information is encrypted, stored securely, and never shared with third parties without your consent. We comply with all UAE data protection regulations.',
                'answer_ar' => 'نحن نأخذ خصوصية البيانات على محمل الجد. يتم تشفير معلوماتك وتخزينها بشكل آمن ولا تتم مشاركتها مع أطراف ثالثة دون موافقتك. نحن نمتثل لجميع لوائح حماية البيانات في الإمارات.',
                'order' => 18,
                'is_active' => true,
            ],
            [
                'category' => 'privacy',
                'question' => 'Can I export my data?',
                'question_ar' => 'هل يمكنني تصدير بياناتي؟',
                'answer' => 'Yes! Go to Settings > Privacy > Request Data Export. We\'ll email you a complete copy of your data within 7 days as per GDPR requirements.',
                'answer_ar' => 'نعم! انتقل إلى الإعدادات > الخصوصية > طلب تصدير البيانات. سنرسل لك نسخة كاملة من بياناتك عبر البريد الإلكتروني خلال 7 أيام وفقًا لمتطلبات GDPR.',
                'order' => 19,
                'is_active' => true,
            ],
        ];

        foreach ($faqs as $faq) {
            Faq::create($faq);
        }

        $this->command->info('FAQs seeded successfully!');
        $this->command->info('Total FAQs created: ' . count($faqs));
    }
}
