<?php

namespace Database\Seeders;

use App\Models\NotificationTemplate;
use Illuminate\Database\Seeder;

class NotificationTemplateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $templates = [
            // Account notifications
            [
                'code' => 'welcome',
                'name' => 'Welcome Email',
                'category' => 'account',
                'description' => 'Sent when user registers',
                'email_subject' => 'Welcome to Privasee, {{user_name}}!',
                'email_body' => 'Hi {{user_name}},\n\nWelcome to Privasee! We\'re excited to have you on board.\n\nStart exploring exclusive offers from the best venues in UAE.\n\nBest regards,\nPrivasee Team',
                'email_enabled' => true,
                'sms_body' => null,
                'sms_enabled' => false,
                'push_title' => 'Welcome to Privasee!',
                'push_body' => 'Start exploring exclusive offers from top venues in UAE',
                'push_enabled' => true,
                'available_variables' => ['user_name', 'email'],
                'is_active' => true,
            ],
            [
                'code' => 'email_verified',
                'name' => 'Email Verified',
                'category' => 'account',
                'description' => 'Sent when email is verified',
                'email_subject' => 'Email Verified Successfully',
                'email_body' => 'Hi {{user_name}},\n\nYour email has been verified successfully. You now have full access to all features.\n\nBest regards,\nPrivasee Team',
                'email_enabled' => true,
                'sms_body' => null,
                'sms_enabled' => false,
                'push_title' => 'Email Verified',
                'push_body' => 'Your email has been verified successfully!',
                'push_enabled' => true,
                'available_variables' => ['user_name'],
                'is_active' => true,
            ],
            [
                'code' => 'password_reset',
                'name' => 'Password Reset',
                'category' => 'account',
                'description' => 'Password reset link',
                'email_subject' => 'Reset Your Password',
                'email_body' => 'Hi {{user_name}},\n\nClick the link below to reset your password:\n{{reset_link}}\n\nThis link expires in 60 minutes.\n\nBest regards,\nPrivasee Team',
                'email_enabled' => true,
                'sms_body' => 'Your Privasee password reset code: {{otp}}',
                'sms_enabled' => true,
                'push_title' => null,
                'push_body' => null,
                'push_enabled' => false,
                'available_variables' => ['user_name', 'reset_link', 'otp'],
                'is_active' => true,
            ],

            // Offer notifications
            [
                'code' => 'offer_new',
                'name' => 'New Offer Available',
                'category' => 'offer_new',
                'description' => 'New offer published',
                'email_subject' => 'New Offer: {{offer_title}}',
                'email_body' => 'Hi {{user_name}},\n\nA new offer is available at {{venue_name}}:\n\n{{offer_title}}\n{{offer_description}}\n\nValid until: {{valid_until}}\n\nRedeem now!\n\nBest regards,\nPrivasee Team',
                'email_enabled' => true,
                'sms_body' => 'New offer at {{venue_name}}: {{offer_title}}. Valid until {{valid_until}}',
                'sms_enabled' => false,
                'push_title' => 'New Offer at {{venue_name}}',
                'push_body' => '{{offer_title}} - Valid until {{valid_until}}',
                'push_enabled' => true,
                'available_variables' => ['user_name', 'offer_title', 'offer_description', 'venue_name', 'valid_until'],
                'is_active' => true,
            ],
            [
                'code' => 'offer_exclusive',
                'name' => 'Exclusive Offer',
                'category' => 'offer_exclusive',
                'description' => 'Exclusive offer for premium members',
                'email_subject' => 'Exclusive Offer Just For You!',
                'email_body' => 'Hi {{user_name}},\n\nAs a premium member, you have access to this exclusive offer:\n\n{{offer_title}}\n{{offer_description}}\n\nValid until: {{valid_until}}\n\nBest regards,\nPrivasee Team',
                'email_enabled' => true,
                'sms_body' => 'Exclusive offer for you: {{offer_title}} at {{venue_name}}',
                'sms_enabled' => false,
                'push_title' => 'Exclusive Offer Just For You',
                'push_body' => '{{offer_title}} at {{venue_name}}',
                'push_enabled' => true,
                'available_variables' => ['user_name', 'offer_title', 'offer_description', 'venue_name', 'valid_until'],
                'is_active' => true,
            ],
            [
                'code' => 'offer_expiring',
                'name' => 'Offer Expiring Soon',
                'category' => 'offer_update',
                'description' => 'Offer expiring in 3 days',
                'email_subject' => 'Offer Expiring Soon: {{offer_title}}',
                'email_body' => 'Hi {{user_name}},\n\nThis offer expires in {{days_left}} days:\n\n{{offer_title}}\n{{venue_name}}\n\nDon\'t miss out!\n\nBest regards,\nPrivasee Team',
                'email_enabled' => true,
                'sms_body' => null,
                'sms_enabled' => false,
                'push_title' => 'Offer Expiring Soon',
                'push_body' => '{{offer_title}} expires in {{days_left}} days',
                'push_enabled' => true,
                'available_variables' => ['user_name', 'offer_title', 'venue_name', 'days_left'],
                'is_active' => true,
            ],

            // Redemption notifications
            [
                'code' => 'redemption_success',
                'name' => 'Redemption Success',
                'category' => 'redemption',
                'description' => 'Offer redeemed successfully',
                'email_subject' => 'Offer Redeemed Successfully',
                'email_body' => 'Hi {{user_name}},\n\nYou have successfully redeemed:\n\n{{offer_title}}\n{{venue_name}}\n\nRedemption Code: {{redemption_code}}\n\nShow this code at the venue.\n\nBest regards,\nPrivasee Team',
                'email_enabled' => true,
                'sms_body' => 'Redemption code for {{offer_title}}: {{redemption_code}}. Valid until {{expires_at}}',
                'sms_enabled' => true,
                'push_title' => 'Offer Redeemed!',
                'push_body' => 'Your redemption code: {{redemption_code}}',
                'push_enabled' => true,
                'available_variables' => ['user_name', 'offer_title', 'venue_name', 'redemption_code', 'expires_at'],
                'is_active' => true,
            ],
            [
                'code' => 'redemption_complete',
                'name' => 'Redemption Complete',
                'category' => 'redemption',
                'description' => 'Redemption completed at venue',
                'email_subject' => 'Redemption Complete',
                'email_body' => 'Hi {{user_name}},\n\nYour redemption has been completed at {{venue_name}}.\n\nWe hope you enjoyed your experience!\n\nBest regards,\nPrivasee Team',
                'email_enabled' => true,
                'sms_body' => null,
                'sms_enabled' => false,
                'push_title' => 'Redemption Complete',
                'push_body' => 'Thank you for visiting {{venue_name}}!',
                'push_enabled' => true,
                'available_variables' => ['user_name', 'venue_name', 'offer_title'],
                'is_active' => true,
            ],

            // Subscription notifications
            [
                'code' => 'subscription_activated',
                'name' => 'Subscription Activated',
                'category' => 'subscription',
                'description' => 'Subscription activated',
                'email_subject' => 'Subscription Activated',
                'email_body' => 'Hi {{user_name}},\n\nYour {{plan_name}} subscription has been activated!\n\nYou now have access to:\n{{features}}\n\nBest regards,\nPrivasee Team',
                'email_enabled' => true,
                'sms_body' => null,
                'sms_enabled' => false,
                'push_title' => 'Subscription Activated',
                'push_body' => 'Welcome to {{plan_name}}!',
                'push_enabled' => true,
                'available_variables' => ['user_name', 'plan_name', 'features', 'expires_at'],
                'is_active' => true,
            ],
            [
                'code' => 'subscription_expiring',
                'name' => 'Subscription Expiring',
                'category' => 'subscription',
                'description' => 'Subscription expiring soon',
                'email_subject' => 'Your Subscription Expires Soon',
                'email_body' => 'Hi {{user_name}},\n\nYour {{plan_name}} subscription expires in {{days_left}} days.\n\nRenew now to continue enjoying exclusive offers!\n\nBest regards,\nPrivasee Team',
                'email_enabled' => true,
                'sms_body' => 'Your Privasee subscription expires in {{days_left}} days. Renew now!',
                'sms_enabled' => true,
                'push_title' => 'Subscription Expiring Soon',
                'push_body' => 'Renew your {{plan_name}} subscription now',
                'push_enabled' => true,
                'available_variables' => ['user_name', 'plan_name', 'days_left'],
                'is_active' => true,
            ],

            // Spotlight notifications
            [
                'code' => 'spotlight_liked',
                'name' => 'Spotlight Liked',
                'category' => 'spotlight',
                'description' => 'Someone liked your spotlight',
                'email_subject' => null,
                'email_body' => null,
                'email_enabled' => false,
                'sms_body' => null,
                'sms_enabled' => false,
                'push_title' => 'New Like',
                'push_body' => '{{liker_name}} liked your spotlight',
                'push_enabled' => true,
                'available_variables' => ['user_name', 'liker_name'],
                'is_active' => true,
            ],
            [
                'code' => 'spotlight_commented',
                'name' => 'Spotlight Commented',
                'category' => 'spotlight',
                'description' => 'Someone commented on spotlight',
                'email_subject' => null,
                'email_body' => null,
                'email_enabled' => false,
                'sms_body' => null,
                'sms_enabled' => false,
                'push_title' => 'New Comment',
                'push_body' => '{{commenter_name}} commented on your spotlight',
                'push_enabled' => true,
                'available_variables' => ['user_name', 'commenter_name', 'comment'],
                'is_active' => true,
            ],

            // System notifications
            [
                'code' => 'system_maintenance',
                'name' => 'System Maintenance',
                'category' => 'system',
                'description' => 'Scheduled maintenance notice',
                'email_subject' => 'Scheduled Maintenance Notice',
                'email_body' => 'Hi {{user_name}},\n\nPrivasee will be undergoing scheduled maintenance on {{date}} at {{time}}.\n\nExpected downtime: {{duration}}\n\nWe apologize for any inconvenience.\n\nBest regards,\nPrivasee Team',
                'email_enabled' => true,
                'sms_body' => null,
                'sms_enabled' => false,
                'push_title' => 'Scheduled Maintenance',
                'push_body' => 'Privasee maintenance on {{date}} at {{time}}',
                'push_enabled' => true,
                'available_variables' => ['user_name', 'date', 'time', 'duration'],
                'is_active' => true,
            ],

            // Marketing notifications
            [
                'code' => 'marketing_campaign',
                'name' => 'Marketing Campaign',
                'category' => 'marketing',
                'description' => 'Generic marketing campaign',
                'email_subject' => '{{campaign_title}}',
                'email_body' => '{{campaign_body}}',
                'email_enabled' => true,
                'sms_body' => '{{campaign_sms}}',
                'sms_enabled' => false,
                'push_title' => '{{campaign_title}}',
                'push_body' => '{{campaign_body}}',
                'push_enabled' => true,
                'available_variables' => ['user_name', 'campaign_title', 'campaign_body', 'campaign_sms'],
                'is_active' => true,
            ],
        ];

        foreach ($templates as $template) {
            NotificationTemplate::updateOrCreate(
                ['code' => $template['code']],
                $template
            );
        }
    }
}
