<?php

namespace Database\Seeders;

use App\Models\SystemConfiguration;
use Illuminate\Database\Seeder;

class SystemConfigurationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $configs = [
            // General Settings
            ['key' => 'app_name', 'value' => 'Privasee', 'type' => 'string', 'description' => 'Application name'],
            ['key' => 'app_tagline', 'value' => 'Your Premium Lifestyle Platform', 'type' => 'string', 'description' => 'Application tagline'],
            ['key' => 'support_email', 'value' => 'support@privasee.com', 'type' => 'string', 'description' => 'Support email address'],
            ['key' => 'support_phone', 'value' => '+971-4-123-4567', 'type' => 'string', 'description' => 'Support phone number'],
            ['key' => 'currency', 'value' => 'AED', 'type' => 'string', 'description' => 'Default currency'],
            ['key' => 'timezone', 'value' => 'Asia/Dubai', 'type' => 'string', 'description' => 'Application timezone'],
            ['key' => 'date_format', 'value' => 'd/m/Y', 'type' => 'string', 'description' => 'Date format'],
            ['key' => 'time_format', 'value' => 'H:i', 'type' => 'string', 'description' => 'Time format'],

            // Feature Toggles
            ['key' => 'guest_browsing_enabled', 'value' => 'true', 'type' => 'boolean', 'description' => 'Allow guests to browse venues'],
            ['key' => 'guest_offers_enabled', 'value' => 'false', 'type' => 'boolean', 'description' => 'Allow guests to view offers'],
            ['key' => 'referral_system_enabled', 'value' => 'true', 'type' => 'boolean', 'description' => 'Enable referral system'],
            ['key' => 'multi_language_enabled', 'value' => 'true', 'type' => 'boolean', 'description' => 'Enable multi-language support'],
            ['key' => 'spotlight_moderation_enabled', 'value' => 'false', 'type' => 'boolean', 'description' => 'Require admin approval for spotlights'],
            ['key' => 'messaging_enabled', 'value' => 'true', 'type' => 'boolean', 'description' => 'Enable user-to-business messaging'],
            ['key' => 'venue_approval_required', 'value' => 'true', 'type' => 'boolean', 'description' => 'Require admin approval for new venues'],
            ['key' => 'offer_approval_required', 'value' => 'true', 'type' => 'boolean', 'description' => 'Require admin approval for new offers'],

            // Languages
            ['key' => 'default_language', 'value' => 'en', 'type' => 'string', 'description' => 'Default application language'],
            ['key' => 'supported_languages', 'value' => 'en,ar', 'type' => 'string', 'description' => 'Comma-separated list of supported languages'],

            // User Settings
            ['key' => 'min_age_requirement', 'value' => '18', 'type' => 'integer', 'description' => 'Minimum age to register'],
            ['key' => 'email_verification_required', 'value' => 'true', 'type' => 'boolean', 'description' => 'Require email verification'],
            ['key' => 'phone_verification_required', 'value' => 'false', 'type' => 'boolean', 'description' => 'Require phone verification'],
            ['key' => 'profile_picture_required', 'value' => 'false', 'type' => 'boolean', 'description' => 'Require profile picture'],

            // Redemption Settings
            ['key' => 'redemption_code_length', 'value' => '12', 'type' => 'integer', 'description' => 'Length of redemption code'],
            ['key' => 'redemption_code_expiry_hours', 'value' => '24', 'type' => 'integer', 'description' => 'Hours until redemption code expires'],
            ['key' => 'max_redemptions_per_day', 'value' => '10', 'type' => 'integer', 'description' => 'Maximum redemptions per user per day'],

            // Spotlight Settings
            ['key' => 'spotlight_max_images', 'value' => '5', 'type' => 'integer', 'description' => 'Maximum images per spotlight'],
            ['key' => 'spotlight_max_video_size_mb', 'value' => '50', 'type' => 'integer', 'description' => 'Maximum video size in MB'],
            ['key' => 'spotlight_auto_flag_threshold', 'value' => '5', 'type' => 'integer', 'description' => 'Number of flags before auto-removal'],

            // Subscription Settings
            ['key' => 'trial_period_days', 'value' => '7', 'type' => 'integer', 'description' => 'Trial period in days'],
            ['key' => 'grace_period_days', 'value' => '3', 'type' => 'integer', 'description' => 'Grace period after subscription expires'],
            ['key' => 'subscription_reminder_days', 'value' => '7', 'type' => 'integer', 'description' => 'Days before expiry to send reminder'],

            // Notification Settings
            ['key' => 'email_notifications_enabled', 'value' => 'true', 'type' => 'boolean', 'description' => 'Enable email notifications'],
            ['key' => 'sms_notifications_enabled', 'value' => 'true', 'type' => 'boolean', 'description' => 'Enable SMS notifications'],
            ['key' => 'push_notifications_enabled', 'value' => 'true', 'type' => 'boolean', 'description' => 'Enable push notifications'],

            // Business Settings
            ['key' => 'business_verification_required', 'value' => 'true', 'type' => 'boolean', 'description' => 'Require business verification'],
            ['key' => 'business_document_required', 'value' => 'true', 'type' => 'boolean', 'description' => 'Require business documents'],
            ['key' => 'min_team_members', 'value' => '1', 'type' => 'integer', 'description' => 'Minimum team members allowed'],
            ['key' => 'max_team_members_startup', 'value' => '3', 'type' => 'integer', 'description' => 'Maximum team members for Startup plan'],
            ['key' => 'max_team_members_sme', 'value' => '10', 'type' => 'integer', 'description' => 'Maximum team members for SME plan'],
            ['key' => 'max_team_members_enterprise', 'value' => '50', 'type' => 'integer', 'description' => 'Maximum team members for Enterprise plan'],

            // Referral Settings
            ['key' => 'referral_reward_type', 'value' => 'days', 'type' => 'string', 'description' => 'Type of referral reward (days, discount, credit)'],
            ['key' => 'referral_reward_value', 'value' => '30', 'type' => 'integer', 'description' => 'Value of referral reward'],
            ['key' => 'referral_min_redemptions', 'value' => '1', 'type' => 'integer', 'description' => 'Minimum redemptions before referral counts'],

            // Analytics Settings
            ['key' => 'ga4_enabled', 'value' => 'true', 'type' => 'boolean', 'description' => 'Enable Google Analytics GA4'],
            ['key' => 'meta_pixel_enabled', 'value' => 'true', 'type' => 'boolean', 'description' => 'Enable Meta (Facebook) Pixel'],

            // Marketing Settings
            ['key' => 'mailchimp_enabled', 'value' => 'true', 'type' => 'boolean', 'description' => 'Enable Mailchimp integration'],
            ['key' => 'mailchimp_auto_sync_users', 'value' => 'true', 'type' => 'boolean', 'description' => 'Auto-sync new users to Mailchimp'],
            ['key' => 'mailchimp_auto_sync_businesses', 'value' => 'false', 'type' => 'boolean', 'description' => 'Auto-sync businesses to Mailchimp'],

            // CRM Settings
            ['key' => 'crm_provider', 'value' => 'hubspot', 'type' => 'string', 'description' => 'CRM provider (hubspot, salesforce)'],
            ['key' => 'hubspot_enabled', 'value' => 'true', 'type' => 'boolean', 'description' => 'Enable HubSpot integration'],
            ['key' => 'hubspot_auto_sync', 'value' => 'true', 'type' => 'boolean', 'description' => 'Auto-sync contacts to HubSpot'],

            // Payment Settings
            ['key' => 'stripe_enabled', 'value' => 'true', 'type' => 'boolean', 'description' => 'Enable Stripe payments'],
            ['key' => 'paypal_enabled', 'value' => 'true', 'type' => 'boolean', 'description' => 'Enable PayPal payments'],

            // SMS Settings
            ['key' => 'twilio_enabled', 'value' => 'true', 'type' => 'boolean', 'description' => 'Enable Twilio SMS'],

            // Social Login
            ['key' => 'google_login_enabled', 'value' => 'true', 'type' => 'boolean', 'description' => 'Enable Google OAuth'],
            ['key' => 'facebook_login_enabled', 'value' => 'true', 'type' => 'boolean', 'description' => 'Enable Facebook OAuth'],

            // Firebase Settings
            ['key' => 'fcm_enabled', 'value' => 'true', 'type' => 'boolean', 'description' => 'Enable Firebase Cloud Messaging'],

            // Maintenance
            ['key' => 'maintenance_mode', 'value' => 'false', 'type' => 'boolean', 'description' => 'Enable maintenance mode'],
            ['key' => 'maintenance_message', 'value' => 'We are currently performing scheduled maintenance. We\'ll be back soon!', 'type' => 'text', 'description' => 'Maintenance mode message'],

            // Rate Limiting
            ['key' => 'api_rate_limit', 'value' => '60', 'type' => 'integer', 'description' => 'API requests per minute'],
            ['key' => 'login_rate_limit', 'value' => '5', 'type' => 'integer', 'description' => 'Login attempts per minute'],

            // File Upload
            ['key' => 'max_upload_size_mb', 'value' => '10', 'type' => 'integer', 'description' => 'Maximum file upload size in MB'],
            ['key' => 'allowed_image_types', 'value' => 'jpg,jpeg,png,gif,webp', 'type' => 'string', 'description' => 'Allowed image file types'],
            ['key' => 'allowed_document_types', 'value' => 'pdf,doc,docx', 'type' => 'string', 'description' => 'Allowed document file types'],
        ];

        foreach ($configs as $config) {
            SystemConfiguration::updateOrCreate(
                ['key' => $config['key']],
                [
                    'value' => $config['value'],
                    'type' => $config['type'],
                    'description' => $config['description'],
                ]
            );
        }

        $this->command->info('System configurations seeded successfully!');
        $this->command->info('Total configurations: ' . count($configs));
    }
}
