@extends('layouts.admin')

@section('title', 'Admin Dashboard')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="fw-bold mb-1">Dashboard Overview</h2>
            <p class="text-muted mb-0">Welcome back! Here's what's happening with your platform today.</p>
        </div>
        <div class="d-flex gap-2">
            <select class="form-select" style="width: 150px;">
                <option>Last 7 days</option>
                <option>Last 30 days</option>
                <option>Last 90 days</option>
                <option>This year</option>
            </select>
            <button class="btn btn-primary">
                <i class="bi bi-download me-2"></i>Export Report
            </button>
        </div>
    </div>

    <!-- Key Metrics -->
    <div class="row g-4 mb-4">
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-icon" style="background: linear-gradient(135deg, #1a73e8 0%, #4285f4 100%); color: white;">
                    <i class="bi bi-people"></i>
                </div>
                <div class="stat-label">Total Users</div>
                <div class="stat-value">{{ number_format($overview['total_users'] ?? 0) }}</div>
                <div class="stat-change positive">
                    <i class="bi bi-arrow-up"></i> {{ $overview['new_users_today'] ?? 0 }} new today
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-icon" style="background: linear-gradient(135deg, #34a853 0%, #7cb342 100%); color: white;">
                    <i class="bi bi-building"></i>
                </div>
                <div class="stat-label">Active Businesses</div>
                <div class="stat-value">{{ number_format($overview['verified_businesses'] ?? 0) }}</div>
                <div class="stat-change positive">
                    <i class="bi bi-hourglass-split"></i> {{ $overview['pending_verification'] ?? 0 }} pending
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-icon" style="background: linear-gradient(135deg, #ea4335 0%, #f44336 100%); color: white;">
                    <i class="bi bi-tag"></i>
                </div>
                <div class="stat-label">Active Offers</div>
                <div class="stat-value">{{ number_format($overview['active_offers'] ?? 0) }}</div>
                <div class="stat-change positive">
                    <i class="bi bi-tag"></i> {{ $overview['total_offers'] ?? 0 }} total
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-icon" style="background: linear-gradient(135deg, #fbbc04 0%, #ffa000 100%); color: white;">
                    <i class="bi bi-wallet2"></i>
                </div>
                <div class="stat-label">Revenue (AED)</div>
                <div class="stat-value">{{ number_format($revenue['total_revenue'] ?? 0, 2) }}</div>
                <div class="stat-change positive">
                    <i class="bi bi-wallet2"></i> {{ number_format($revenue['revenue_today'] ?? 0, 2) }} today
                </div>
            </div>
        </div>
    </div>

    <!-- Secondary Metrics -->
    <div class="row g-4 mb-4">
        <div class="col-md-2">
            <div class="stat-card">
                <div class="stat-label">New Users Today</div>
                <div class="stat-value" style="font-size: 24px;">{{ $overview['new_users_today'] ?? 0 }}</div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="stat-card">
                <div class="stat-label">Pending Verifications</div>
                <div class="stat-value" style="font-size: 24px; color: var(--admin-warning);">{{ $overview['pending_verification'] ?? 0 }}</div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="stat-card">
                <div class="stat-label">Total Redemptions</div>
                <div class="stat-value" style="font-size: 24px;">{{ number_format($overview['total_redemptions'] ?? 0) }}</div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="stat-card">
                <div class="stat-label">Active Subscriptions</div>
                <div class="stat-value" style="font-size: 24px;">{{ $overview['active_subscriptions'] ?? 0 }}</div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="stat-card">
                <div class="stat-label">Flagged Content</div>
                <div class="stat-value" style="font-size: 24px; color: var(--admin-danger);">{{ $overview['flagged_content'] ?? 0 }}</div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="stat-card">
                <div class="stat-label">Open Tickets</div>
                <div class="stat-value" style="font-size: 24px;">{{ $overview['pending_redemptions'] ?? 0 }}</div>
            </div>
        </div>
    </div>

    <!-- Charts Row -->
    <div class="row g-4 mb-4">
        <div class="col-lg-8">
            <div class="admin-card">
                <div class="admin-card-header">
                    <h5 class="mb-0 fw-bold">User Growth & Revenue</h5>
                </div>
                <div class="admin-card-body">
                    <canvas id="growthChart" height="80"></canvas>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="admin-card">
                <div class="admin-card-header">
                    <h5 class="mb-0 fw-bold">Business by Status</h5>
                </div>
                <div class="admin-card-body">
                    <canvas id="businessStatusChart"></canvas>
                    <div class="mt-3">
                        <div class="d-flex justify-content-between mb-2">
                            <span class="small"><i class="bi bi-circle-fill text-success me-2"></i>Verified</span>
                            <span class="fw-semibold">{{ $overview['verified_businesses'] ?? 0 }}</span>
                        </div>
                        <div class="d-flex justify-content-between mb-2">
                            <span class="small"><i class="bi bi-circle-fill text-warning me-2"></i>Pending</span>
                            <span class="fw-semibold">{{ $overview['pending_verification'] ?? 0 }}</span>
                        </div>
                        <div class="d-flex justify-content-between mb-2">
                            <span class="small"><i class="bi bi-circle-fill text-primary me-2"></i>Total</span>
                            <span class="fw-semibold">{{ $overview['total_businesses'] ?? 0 }}</span>
                        </div>
                        <div class="d-flex justify-content-between">
                            <span class="small"><i class="bi bi-circle-fill text-info me-2"></i>Venues</span>
                            <span class="fw-semibold">{{ $overview['total_venues'] ?? 0 }}</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Activity Tables Row -->
    <div class="row g-4 mb-4">
        <div class="col-lg-6">
            <div class="admin-card">
                <div class="admin-card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0 fw-bold">Recent Users</h5>
                    <a href="{{ route('admin.users.index') }}" class="btn btn-sm btn-outline-primary">View All</a>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead>
                            <tr>
                                <th>User</th>
                                <th>Email</th>
                                <th>Joined</th>
                                <th>Status</th>
                            </tr>
                            </thead>
                            <tbody>
                            @forelse($recentUsers ?? [] as $user)
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <img src="{{ $user->profile_image ?? 'https://ui-avatars.com/api/?name='.$user->full_name }}"
                                                 class="rounded-circle me-2" width="32" height="32">
                                            <span class="fw-semibold">{{ $user->full_name }}</span>
                                        </div>
                                    </td>
                                    <td>{{ $user->email }}</td>
                                    <td>{{ $user->created_at->diffForHumans() }}</td>
                                    <td>
                                        <span class="badge bg-success">Active</span>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="4" class="text-center text-muted py-3">No recent users</td>
                                </tr>
                            @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="admin-card">
                <div class="admin-card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0 fw-bold">Pending Verifications</h5>
                    <a href="{{ route('admin.businesses.index', ['status' => 'pending']) }}" class="btn btn-sm btn-outline-warning">View All</a>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead>
                            <tr>
                                <th>Business</th>
                                <th>Owner</th>
                                <th>Submitted</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            @forelse($pendingBusinesses ?? [] as $business)
                                <tr>
                                    <td class="fw-semibold">{{ $business->business_name }}</td>
                                    <td>{{ $business->owner->full_name ?? 'N/A' }}</td>
                                    <td>{{ $business->created_at->diffForHumans() }}</td>
                                    <td>
                                        <a href="{{ route('admin.businesses.show', $business->id) }}" class="btn btn-sm btn-primary">
                                            Review
                                        </a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="4" class="text-center text-muted py-3">No pending verifications</td>
                                </tr>
                            @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Activity -->
    <div class="row g-4">
        <div class="col-lg-12">
            <div class="admin-card">
                <div class="admin-card-header">
                    <h5 class="mb-0 fw-bold">Recent Activity</h5>
                </div>
                <div class="card-body px-4">
                    <div class="list-group list-group-flush">
                        @if($recentBusinesses->count() > 0)
                            @foreach($recentBusinesses as $business)
                                <div class="list-group-item border-0 px-0">
                                    <div class="d-flex align-items-start">
                                        <div class="me-3">
                                            <div class="rounded-circle bg-primary bg-opacity-10 d-flex align-items-center justify-content-center"
                                                 style="width: 40px; height: 40px;">
                                                <i class="bi bi-building text-primary"></i>
                                            </div>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="d-flex justify-content-between">
                                                <h6 class="mb-1">New Business Registration</h6>
                                                <small class="text-muted">{{ $business->created_at->diffForHumans() }}</small>
                                            </div>
                                            <p class="text-muted mb-0 small">{{ $business->business_name }} registered by {{ $business->owner->full_name ?? 'N/A' }}</p>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        @else
                            <div class="text-center text-muted py-4">
                                <i class="bi bi-inbox fs-1 d-block mb-2"></i>
                                <p>No recent activity</p>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
    <script>
        // Growth Chart
        const growthCtx = document.getElementById('growthChart').getContext('2d');
        new Chart(growthCtx, {
            type: 'line',
            data: {
                labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
                datasets: [{
                    label: 'Users',
                    data: [850, 920, 1050, 1180, 1320, 1450, 1600, 1780, 1950, 2100, 2280, 2450],
                    borderColor: '#1a73e8',
                    backgroundColor: 'rgba(26, 115, 232, 0.1)',
                    tension: 0.4,
                    fill: true
                }, {
                    label: 'Revenue (x100 AED)',
                    data: [120, 145, 165, 190, 220, 250, 285, 320, 360, 395, 430, 470],
                    borderColor: '#34a853',
                    backgroundColor: 'rgba(52, 168, 83, 0.1)',
                    tension: 0.4,
                    fill: true
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: true,
                plugins: {
                    legend: {
                        position: 'top',
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });

        // Business Status Chart
        const statusCtx = document.getElementById('businessStatusChart').getContext('2d');
        new Chart(statusCtx, {
            type: 'doughnut',
            data: {
                labels: ['Verified', 'Pending', 'Rejected', 'Suspended'],
                datasets: [{
                    data: [398, 67, 12, 10],
                    backgroundColor: ['#34a853', '#fbbc04', '#ea4335', '#6b7280']
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: true,
                plugins: {
                    legend: {
                        display: false
                    }
                }
            }
        });
    </script>
@endpush
