@extends('layouts.admin')

@section('title', 'Edit Offer - ' . $offer->title)

@section('content')
    <div class="admin-header mb-4">
        <div>
            <h2>Edit Offer</h2>
            <p class="text-muted mb-0">Update offer details</p>
        </div>
        <div class="d-flex gap-2">
            <a href="{{ route('admin.offers.show', $offer->id) }}" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left me-2"></i>Back
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <form action="{{ route('admin.offers.update', $offer->id) }}" method="POST">
                @csrf
                @method('PUT')

                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white border-bottom">
                        <h5 class="mb-0 fw-bold">Basic Information</h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Venue <span class="text-danger">*</span></label>
                                <select class="form-select @error('venue_id') is-invalid @enderror" name="venue_id" required>
                                    <option value="">Select Venue</option>
                                    @foreach($venues as $venue)
                                        <option value="{{ $venue->id }}" {{ old('venue_id', $offer->venue_id) == $venue->id ? 'selected' : '' }}>
                                            {{ $venue->name }} ({{ $venue->business->business_name }})
                                        </option>
                                    @endforeach
                                </select>
                                @error('venue_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Category <span class="text-danger">*</span></label>
                                <select class="form-select @error('category_id') is-invalid @enderror" name="category_id" required>
                                    <option value="">Select Category</option>
                                    @foreach($categories as $category)
                                        <option value="{{ $category->id }}" {{ old('category_id', $offer->category_id) == $category->id ? 'selected' : '' }}>
                                            {{ $category->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('category_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Title (English) <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('title') is-invalid @enderror"
                                       name="title" value="{{ old('title', $offer->title) }}" required>
                                @error('title')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Title (Arabic)</label>
                                <input type="text" class="form-control @error('title_ar') is-invalid @enderror"
                                       name="title_ar" value="{{ old('title_ar', $offer->title_ar) }}" dir="rtl">
                                @error('title_ar')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-12">
                                <label class="form-label">Description (English) <span class="text-danger">*</span></label>
                                <textarea class="form-control @error('description') is-invalid @enderror"
                                          name="description" rows="4" required>{{ old('description', $offer->description) }}</textarea>
                                @error('description')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-12">
                                <label class="form-label">Description (Arabic)</label>
                                <textarea class="form-control @error('description_ar') is-invalid @enderror"
                                          name="description_ar" rows="4" dir="rtl">{{ old('description_ar', $offer->description_ar) }}</textarea>
                                @error('description_ar')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white border-bottom">
                        <h5 class="mb-0 fw-bold">Discount Details</h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Discount Type <span class="text-danger">*</span></label>
                                <select class="form-select @error('discount_type') is-invalid @enderror" name="discount_type" required>
                                    <option value="percentage" {{ old('discount_type', $offer->discount_type) == 'percentage' ? 'selected' : '' }}>Percentage</option>
                                    <option value="fixed" {{ old('discount_type', $offer->discount_type) == 'fixed' ? 'selected' : '' }}>Fixed Amount</option>
                                    <option value="buy_x_get_y" {{ old('discount_type', $offer->discount_type) == 'buy_x_get_y' ? 'selected' : '' }}>Buy X Get Y</option>
                                    <option value="free_item" {{ old('discount_type', $offer->discount_type) == 'free_item' ? 'selected' : '' }}>Free Item</option>
                                </select>
                                @error('discount_type')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Discount Value <span class="text-danger">*</span></label>
                                <input type="number" step="0.01" class="form-control @error('discount_value') is-invalid @enderror"
                                       name="discount_value" value="{{ old('discount_value', $offer->discount_value) }}" required>
                                @error('discount_value')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="text-muted">For percentage: 0-100. For fixed: amount in AED.</small>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Minimum Purchase Amount</label>
                                <input type="number" step="0.01" class="form-control @error('minimum_purchase') is-invalid @enderror"
                                       name="minimum_purchase" value="{{ old('minimum_purchase', $offer->minimum_purchase) }}">
                                @error('minimum_purchase')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Maximum Discount Amount</label>
                                <input type="number" step="0.01" class="form-control @error('max_discount_amount') is-invalid @enderror"
                                       name="max_discount_amount" value="{{ old('max_discount_amount', $offer->max_discount_amount) }}">
                                @error('max_discount_amount')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="text-muted">For percentage discounts only.</small>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white border-bottom">
                        <h5 class="mb-0 fw-bold">Terms & Conditions</h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-12">
                                <label class="form-label">Terms & Conditions (English)</label>
                                <textarea class="form-control @error('terms_conditions') is-invalid @enderror"
                                          name="terms_conditions" rows="4">{{ old('terms_conditions', $offer->terms_conditions) }}</textarea>
                                @error('terms_conditions')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-12">
                                <label class="form-label">Terms & Conditions (Arabic)</label>
                                <textarea class="form-control @error('terms_conditions_ar') is-invalid @enderror"
                                          name="terms_conditions_ar" rows="4" dir="rtl">{{ old('terms_conditions_ar', $offer->terms_conditions_ar) }}</textarea>
                                @error('terms_conditions_ar')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white border-bottom">
                        <h5 class="mb-0 fw-bold">Validity & Limits</h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Start Date <span class="text-danger">*</span></label>
                                <input type="date" class="form-control @error('start_date') is-invalid @enderror"
                                       name="start_date" value="{{ old('start_date', $offer->start_date ? $offer->start_date->format('Y-m-d') : '') }}" required>
                                @error('start_date')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">End Date <span class="text-danger">*</span></label>
                                <input type="date" class="form-control @error('end_date') is-invalid @enderror"
                                       name="end_date" value="{{ old('end_date', $offer->end_date ? $offer->end_date->format('Y-m-d') : '') }}" required>
                                @error('end_date')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Total Redemption Limit</label>
                                <input type="number" class="form-control @error('redemption_limit') is-invalid @enderror"
                                       name="redemption_limit" value="{{ old('redemption_limit', $offer->redemption_limit) }}">
                                @error('redemption_limit')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="text-muted">Leave empty for unlimited.</small>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Per User Redemption Limit</label>
                                <input type="number" class="form-control @error('user_redemption_limit') is-invalid @enderror"
                                       name="user_redemption_limit" value="{{ old('user_redemption_limit', $offer->user_redemption_limit) }}">
                                @error('user_redemption_limit')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="text-muted">Leave empty for unlimited.</small>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white border-bottom">
                        <h5 class="mb-0 fw-bold">Settings</h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Status <span class="text-danger">*</span></label>
                                <select class="form-select @error('status') is-invalid @enderror" name="status" required>
                                    <option value="active" {{ old('status', $offer->status) == 'active' ? 'selected' : '' }}>Active</option>
                                    <option value="inactive" {{ old('status', $offer->status) == 'inactive' ? 'selected' : '' }}>Inactive</option>
                                    <option value="expired" {{ old('status', $offer->status) == 'expired' ? 'selected' : '' }}>Expired</option>
                                </select>
                                @error('status')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Featured</label>
                                <div class="form-check form-switch mt-2">
                                    <input class="form-check-input" type="checkbox" name="is_featured"
                                           value="1" {{ old('is_featured', $offer->is_featured) ? 'checked' : '' }}>
                                    <label class="form-check-label">Mark as featured offer</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="d-flex gap-2">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-circle me-2"></i>Update Offer
                    </button>
                    <a href="{{ route('admin.offers.show', $offer->id) }}" class="btn btn-outline-secondary">
                        Cancel
                    </a>
                </div>
            </form>
        </div>

        <div class="col-lg-4">
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white border-bottom">
                    <h5 class="mb-0 fw-bold">Current Information</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="text-muted small">Venue</label>
                        <div class="fw-semibold">{{ $offer->venue->name }}</div>
                    </div>

                    <div class="mb-3">
                        <label class="text-muted small">Business</label>
                        <div class="fw-semibold">{{ $offer->venue->business->business_name }}</div>
                    </div>

                    <div class="mb-3">
                        <label class="text-muted small">Category</label>
                        <div class="fw-semibold">{{ $offer->category->name }}</div>
                    </div>

                    <div class="mb-3">
                        <label class="text-muted small">Status</label>
                        <div>
                            @if($offer->status === 'active')
                                <span class="badge bg-success">Active</span>
                            @elseif($offer->status === 'inactive')
                                <span class="badge bg-secondary">Inactive</span>
                            @else
                                <span class="badge bg-danger">Expired</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="text-muted small">Total Redemptions</label>
                        <div class="fw-semibold">{{ $offer->redemption_count ?? 0 }}</div>
                    </div>

                    <div class="mb-3">
                        <label class="text-muted small">Created</label>
                        <div>{{ $offer->created_at->format('M d, Y') }}</div>
                    </div>

                    <div class="mb-0">
                        <label class="text-muted small">Last Updated</label>
                        <div>{{ $offer->updated_at->format('M d, Y') }}</div>
                    </div>
                </div>
            </div>

            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom">
                    <h5 class="mb-0 fw-bold">Quick Actions</h5>
                </div>
                <div class="card-body">
                    <a href="{{ route('admin.offers.show', $offer->id) }}" class="btn btn-outline-primary w-100 mb-2">
                        <i class="bi bi-eye me-2"></i>View Offer
                    </a>
                    <a href="{{ route('admin.venues.show', $offer->venue_id) }}" class="btn btn-outline-secondary w-100">
                        <i class="bi bi-geo-alt me-2"></i>View Venue
                    </a>
                </div>
            </div>
        </div>
    </div>
@endsection
