@extends('layouts.admin')

@section('title', 'Offers Management')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="fw-bold mb-1">Offers Management</h2>
            <p class="text-muted mb-0">Manage and moderate business offers</p>
        </div>
    </div>

    <!-- Stats -->
    <div class="row g-3 mb-4">
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-label">Total Offers</div>
                <div class="stat-value">{{ number_format($stats['total'] ?? 0) }}</div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-label">Active Offers</div>
                <div class="stat-value text-success">{{ number_format($stats['active'] ?? 0) }}</div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-label">Expired Offers</div>
                <div class="stat-value text-danger">{{ number_format($stats['expired'] ?? 0) }}</div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-label">Total Redemptions</div>
                <div class="stat-value text-primary">{{ number_format($stats['redemptions'] ?? 0) }}</div>
            </div>
        </div>
    </div>

    <!-- Offers Table -->
    <div class="admin-card">
        <div class="admin-card-header">
            <h5 class="mb-0 fw-bold">All Offers ({{ $offers->total() }})</h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                    <tr>
                        <th>Offer</th>
                        <th>Business</th>
                        <th>Venue</th>
                        <th>Discount</th>
                        <th>Status</th>
                        <th>Valid Until</th>
                        <th>Redemptions</th>
                        <th>Actions</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($offers as $offer)
                        <tr>
                            <td>
                                <div class="fw-semibold">{{ $offer->title }}</div>
                                <small class="text-muted">{{ Str::limit($offer->description ?? '', 40) }}</small>
                            </td>
                            <td>{{ $offer->business->business_name ?? 'N/A' }}</td>
                            <td>{{ $offer->venue->name ?? 'All Venues' }}</td>
                            <td>
                                <strong class="text-primary">
                                    @if($offer->discount_type === 'percentage')
                                        {{ $offer->discount_value }}%
                                    @else
                                        AED {{ number_format($offer->discount_value, 2) }}
                                    @endif
                                </strong>
                            </td>
                            <td>
                            <span class="badge bg-{{ $offer->status === 'active' ? 'success' : ($offer->status === 'inactive' ? 'danger' : 'warning') }}">
                                {{ ucfirst($offer->status) }}
                            </span>
                            </td>
                            <td>{{ $offer->end_date ? $offer->end_date->format('M d, Y') : 'No expiry' }}</td>
                            <td>{{ number_format($offer->redemptions_count ?? 0) }} / {{ $offer->max_redemptions ?? '∞' }}</td>
                            <td>
                                <a href="{{ route('admin.offers.show', $offer->id) }}" class="btn btn-sm btn-outline-primary">
                                    <i class="bi bi-eye"></i>
                                </a>
{{--                                edit--}}
                                <a href="{{ route('admin.offers.edit', $offer->id) }}" class="btn btn-sm btn-outline-secondary">
                                    <i class="bi bi-pencil"></i>
                                </a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="text-center text-muted py-4">
                                <i class="bi bi-inbox fs-1 d-block mb-2"></i>
                                No offers found
                            </td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        @if($offers->hasPages())
            <div class="admin-card-footer">
                {{ $offers->links() }}
            </div>
        @endif
    </div>
@endsection
