@extends('layouts.admin')

@section('title', 'Reports & Analytics')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="fw-bold mb-1">Reports & Analytics</h2>
            <p class="text-muted mb-0">View system reports and analytics</p>
        </div>
        <button class="btn btn-primary">
            <i class="bi bi-download me-2"></i>Export Report
        </button>
    </div>

    <div class="row g-4 mb-4">
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-label">Total Revenue</div>
                <div class="stat-value">AED 0</div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-label">Total Users</div>
                <div class="stat-value">0</div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-label">Total Businesses</div>
                <div class="stat-value">0</div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-label">Total Transactions</div>
                <div class="stat-value">0</div>
            </div>
        </div>
    </div>

    <div class="admin-card">
        <div class="admin-card-header">
            <h5 class="mb-0 fw-bold">Report Categories</h5>
        </div>
        <div class="card-body">
            <div class="list-group">
                <a href="#" class="list-group-item list-group-item-action">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="mb-1">User Activity Report</h6>
                            <p class="mb-0 text-muted small">View user engagement and activity metrics</p>
                        </div>
                        <i class="bi bi-chevron-right"></i>
                    </div>
                </a>
                <a href="#" class="list-group-item list-group-item-action">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="mb-1">Revenue Report</h6>
                            <p class="mb-0 text-muted small">View payment and revenue analytics</p>
                        </div>
                        <i class="bi bi-chevron-right"></i>
                    </div>
                </a>
                <a href="#" class="list-group-item list-group-item-action">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="mb-1">Business Performance</h6>
                            <p class="mb-0 text-muted small">View business metrics and performance</p>
                        </div>
                        <i class="bi bi-chevron-right"></i>
                    </div>
                </a>
            </div>
        </div>
    </div>
@endsection
