@extends('layouts.admin')

@section('title', 'Reviews Management')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="fw-bold mb-1">Reviews Management</h2>
            <p class="text-muted mb-0">Manage and moderate user reviews</p>
        </div>
    </div>

    <div class="admin-card">
        <div class="admin-card-header">
            <h5 class="mb-0 fw-bold">All Reviews</h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                    <tr>
                        <th>User</th>
                        <th>Venue</th>
                        <th>Rating</th>
                        <th>Comment</th>
                        <th>Status</th>
                        <th>Date</th>
                        <th>Actions</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($reviews as $review)
                        <tr>
                            <td>{{ $review->user->full_name ?? 'N/A' }}</td>
                            <td>{{ $review->venue->name ?? 'N/A' }}</td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <i class="bi bi-star-fill text-warning me-1"></i>
                                    {{ $review->rating }}
                                </div>
                            </td>
                            <td>{{ Str::limit($review->comment, 50) }}</td>
                            <td>
                            <span class="badge bg-{{ $review->status === 'approved' ? 'success' : ($review->status === 'pending' ? 'warning' : 'danger') }}">
                                {{ ucfirst($review->status) }}
                            </span>
                            </td>
                            <td>{{ $review->created_at->format('M d, Y') }}</td>
                            <td>
                                <button class="btn btn-sm btn-outline-primary">View</button>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="text-center text-muted py-4">No reviews found</td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        @if(isset($reviews) && $reviews->hasPages())
            <div class="admin-card-footer">
                {{ $reviews->links() }}
            </div>
        @endif
    </div>
@endsection
