@extends('layouts.admin')

@section('title', 'Role Users')

@section('content')
    <div class="container-fluid">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h2>Users with Role: {{ $role->display_name }}</h2>
                <p class="text-muted mb-0">View all users assigned to this role</p>
            </div>
            <a href="{{ route('admin.roles.show', $role->id) }}" class="btn btn-secondary">
                <i class="bi bi-arrow-left me-2"></i>Back to Role
            </a>
        </div>

        <div class="card border-0 shadow-sm">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover align-middle">
                        <thead class="table-light">
                        <tr>
                            <th>User</th>
                            <th>Email</th>
                            <th>Account Type</th>
                            <th>Business</th>
                            <th>Status</th>
                            <th>Assigned Date</th>
                            <th class="text-end">Actions</th>
                        </tr>
                        </thead>
                        <tbody>
                        @forelse($users as $user)
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="avatar-sm bg-primary bg-opacity-10 text-primary rounded-circle d-flex align-items-center justify-content-center me-2">
                                            {{ strtoupper(substr($user->name, 0, 1)) }}
                                        </div>
                                        <div>
                                            <strong>{{ $user->name }}</strong>
                                        </div>
                                    </div>
                                </td>
                                <td>{{ $user->email }}</td>
                                <td>
                                <span class="badge bg-{{ $user->account_type === 'business' ? 'success' : 'primary' }}">
                                    {{ ucfirst($user->account_type) }}
                                </span>
                                </td>
                                <td>
                                    @if($user->businesses->isNotEmpty())
                                        {{ $user->businesses->first()->name }}
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td>
                                <span class="badge bg-{{ $user->status === 'active' ? 'success' : 'warning' }}">
                                    {{ ucfirst($user->status) }}
                                </span>
                                </td>
                                <td>{{ $user->pivot->created_at->format('M d, Y H:i') }}</td>
                                <td>
                                    <div class="d-flex justify-content-end gap-2">
                                        <a href="{{ route('admin.users.show', $user->id) }}" class="btn btn-sm btn-light" title="View User">
                                            <i class="bi bi-eye"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center py-5">
                                    <i class="bi bi-people" style="font-size: 3rem; color: #ccc;"></i>
                                    <p class="text-muted mt-3">No users assigned to this role yet</p>
                                </td>
                            </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                @if($users->hasPages())
                    <div class="mt-4">
                        {{ $users->links() }}
                    </div>
                @endif
            </div>
        </div>
    </div>

    <style>
        .avatar-sm {
            width: 40px;
            height: 40px;
            font-size: 1rem;
        }
    </style>
@endsection
