@extends('layouts.admin')

@section('title', 'Spotlight Details')

@section('content')
<div class="container-fluid py-4">
    <div class="row mb-4">
        <div class="col">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h2 class="mb-1">Spotlight Details</h2>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('admin.spotlights.index') }}">Spotlights</a></li>
                            <li class="breadcrumb-item active">#{{ $spotlight->id }}</li>
                        </ol>
                    </nav>
                </div>
                <div>
                    <a href="{{ route('admin.spotlights.index') }}" class="btn btn-outline-secondary">
                        <i class="bi bi-arrow-left me-2"></i>Back to List
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Main Content -->
        <div class="col-lg-8 mb-4">
            <div class="card">
                <div class="card-body">
                    <!-- User Info -->
                    <div class="d-flex align-items-center mb-4">
                        <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px;">
                            {{ strtoupper(substr($spotlight->user->first_name, 0, 1)) }}
                        </div>
                        <div>
                            <h5 class="mb-0">{{ $spotlight->user->full_name }}</h5>
                            <small class="text-muted">{{ $spotlight->created_at->format('M d, Y h:i A') }}</small>
                        </div>
                        @if($spotlight->is_flagged)
                            <span class="badge bg-danger ms-auto">
                                <i class="bi bi-flag-fill me-1"></i>Flagged
                            </span>
                        @endif
                    </div>

                    <!-- Content -->
                    <div class="mb-4">
                        <p class="fs-5">{{ $spotlight->content }}</p>
                    </div>

                    <!-- Media -->
                    @if($spotlight->media)
                        @php $media = json_decode($spotlight->media); @endphp
                        @if(count($media) > 0)
                        <div class="mb-4">
                            <div class="row g-2">
                                @foreach($media as $item)
                                <div class="col-md-6">
                                    <img src="{{ Storage::url($item) }}" class="img-fluid rounded" alt="Spotlight media">
                                </div>
                                @endforeach
                            </div>
                        </div>
                        @endif
                    @endif

                    <!-- Venue Tag -->
                    @if($spotlight->venue)
                    <div class="mb-4">
                        <span class="badge bg-info fs-6">
                            <i class="bi bi-geo-alt-fill me-1"></i>
                            {{ $spotlight->venue->name }}
                        </span>
                    </div>
                    @endif

                    <!-- Engagement Stats -->
                    <div class="d-flex gap-4 mb-4 pb-4 border-bottom">
                        <div>
                            <i class="bi bi-heart-fill text-danger me-2"></i>
                            <span class="fw-medium">{{ $spotlight->likes->count() }}</span>
                            <span class="text-muted">Likes</span>
                        </div>
                        <div>
                            <i class="bi bi-chat-fill text-primary me-2"></i>
                            <span class="fw-medium">{{ $spotlight->comments->count() }}</span>
                            <span class="text-muted">Comments</span>
                        </div>
                    </div>

                    <!-- Comments -->
                    <h5 class="mb-3">Comments ({{ $spotlight->comments->count() }})</h5>
                    @forelse($spotlight->comments as $comment)
                    <div class="d-flex mb-3">
                        <div class="bg-secondary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 40px; height: 40px; flex-shrink: 0;">
                            {{ strtoupper(substr($comment->user->first_name, 0, 1)) }}
                        </div>
                        <div class="flex-grow-1">
                            <div class="bg-light rounded p-3">
                                <h6 class="mb-1">{{ $comment->user->full_name }}</h6>
                                <p class="mb-0">{{ $comment->comment }}</p>
                                <small class="text-muted">{{ $comment->created_at->diffForHumans() }}</small>
                            </div>
                        </div>
                    </div>
                    @empty
                    <div class="text-center py-4 text-muted">
                        <i class="bi bi-chat" style="font-size: 32px;"></i>
                        <p class="mt-2">No comments yet</p>
                    </div>
                    @endforelse
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="col-lg-4">
            <!-- Status Card -->
            <div class="card mb-3">
                <div class="card-header bg-white">
                    <h6 class="mb-0">Status</h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label">Current Status</label>
                        <div>
                            @if($spotlight->status === 'active')
                                <span class="badge bg-success fs-6">Active</span>
                            @elseif($spotlight->status === 'pending')
                                <span class="badge bg-warning fs-6">Pending Review</span>
                            @else
                                <span class="badge bg-danger fs-6">Rejected</span>
                            @endif
                        </div>
                    </div>

                    @if($spotlight->status === 'pending')
                    <div class="d-grid gap-2">
                        <button onclick="approvePost()" class="btn btn-success">
                            <i class="bi bi-check-circle me-2"></i>Approve
                        </button>
                        <button onclick="rejectPost()" class="btn btn-danger">
                            <i class="bi bi-x-circle me-2"></i>Reject
                        </button>
                    </div>
                    @endif

                    @if($spotlight->is_flagged)
                    <button onclick="unflagPost()" class="btn btn-warning w-100 mt-2">
                        <i class="bi bi-flag me-2"></i>Remove Flag
                    </button>
                    @endif
                </div>
            </div>

            <!-- User Info Card -->
            <div class="card mb-3">
                <div class="card-header bg-white">
                    <h6 class="mb-0">User Information</h6>
                </div>
                <div class="card-body">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <th>Name</th>
                            <td>{{ $spotlight->user->full_name }}</td>
                        </tr>
                        <tr>
                            <th>Email</th>
                            <td>{{ $spotlight->user->email }}</td>
                        </tr>
                        <tr>
                            <th>Phone</th>
                            <td>{{ $spotlight->user->phone }}</td>
                        </tr>
                    </table>
                    <a href="{{ route('admin.users.show', $spotlight->user->id) }}" class="btn btn-sm btn-primary w-100">
                        View User Profile
                    </a>
                </div>
            </div>

            <!-- Post Info -->
            <div class="card">
                <div class="card-header bg-white">
                    <h6 class="mb-0">Post Information</h6>
                </div>
                <div class="card-body">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <th>Post ID</th>
                            <td>#{{ $spotlight->id }}</td>
                        </tr>
                        <tr>
                            <th>Created</th>
                            <td>{{ $spotlight->created_at->format('M d, Y h:i A') }}</td>
                        </tr>
                        <tr>
                            <th>Updated</th>
                            <td>{{ $spotlight->updated_at->format('M d, Y h:i A') }}</td>
                        </tr>
                        @if($spotlight->moderation_notes)
                        <tr>
                            <th>Notes</th>
                            <td>{{ $spotlight->moderation_notes }}</td>
                        </tr>
                        @endif
                    </table>
                </div>
            </div>

            <!-- Danger Zone -->
            <div class="card border-danger mt-3">
                <div class="card-header bg-danger text-white">
                    <h6 class="mb-0">Danger Zone</h6>
                </div>
                <div class="card-body">
                    <button onclick="deletePost()" class="btn btn-danger w-100">
                        <i class="bi bi-trash me-2"></i>Delete Post
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function approvePost() {
    if (confirm('Approve this spotlight post?')) {
        fetch(`/admin/spotlights/{{ $spotlight->id }}/approve`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Content-Type': 'application/json',
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            }
        });
    }
}

function rejectPost() {
    const reason = prompt('Reason for rejection (optional):');
    if (reason !== null) {
        fetch(`/admin/spotlights/{{ $spotlight->id }}/reject`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({ notes: reason })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            }
        });
    }
}

function unflagPost() {
    if (confirm('Remove flag from this post?')) {
        fetch(`/admin/spotlights/{{ $spotlight->id }}/unflag`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            }
        });
    }
}

function deletePost() {
    if (confirm('Are you sure you want to delete this post? This cannot be undone.')) {
        fetch(`/admin/spotlights/{{ $spotlight->id }}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                window.location.href = '{{ route('admin.spotlights.index') }}';
            }
        });
    }
}
</script>
@endsection
