@extends('layouts.admin')

@section('title', 'User Subscriptions')

@section('content')
    <div class="container-fluid py-4">
        <!-- Header -->
        <div class="row mb-4">
            <div class="col">
                <h2 class="mb-1">User Subscriptions</h2>
                <p class="text-muted">Manage subscriptions for end-users of the application</p>
            </div>
            <div class="col-auto">
                <a href="{{ route('admin.user-subscriptions.analytics') }}" class="btn btn-outline-primary me-2">
                    <i class="bi bi-graph-up me-2"></i>Analytics
                </a>
                <a href="{{ route('admin.subscription-plans.index', ['type' => 'user']) }}" class="btn btn-primary">
                    <i class="bi bi-card-checklist me-2"></i>Manage Plans
                </a>
            </div>
        </div>

        <!-- Stats Cards -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card border-0 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <p class="text-muted mb-1">Total Subscriptions</p>
                                <h3 class="mb-0">{{ number_format($stats['total']) }}</h3>
                            </div>
                            <div class="bg-primary bg-opacity-10 rounded p-3">
                                <i class="bi bi-people-fill text-primary fs-4"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card border-0 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <p class="text-muted mb-1">Active</p>
                                <h3 class="mb-0 text-success">{{ number_format($stats['active']) }}</h3>
                            </div>
                            <div class="bg-success bg-opacity-10 rounded p-3">
                                <i class="bi bi-check-circle-fill text-success fs-4"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card border-0 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <p class="text-muted mb-1">Expired</p>
                                <h3 class="mb-0 text-warning">{{ number_format($stats['expired']) }}</h3>
                            </div>
                            <div class="bg-warning bg-opacity-10 rounded p-3">
                                <i class="bi bi-clock-fill text-warning fs-4"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card border-0 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <p class="text-muted mb-1">Monthly Revenue</p>
                                <h3 class="mb-0 text-info">AED {{ number_format($stats['monthly_revenue'], 2) }}</h3>
                            </div>
                            <div class="bg-info bg-opacity-10 rounded p-3">
                                <i class="bi bi-currency-dollar text-info fs-4"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filters -->
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-body">
                <div class="row g-3">
                    <div class="col-md-3">
                        <label class="form-label small">Status Filter</label>
                        <select class="form-select" onchange="window.location.href='?status=' + this.value">
                            <option value="all" {{ $status === 'all' ? 'selected' : '' }}>All Status</option>
                            <option value="active" {{ $status === 'active' ? 'selected' : '' }}>Active</option>
                            <option value="expired" {{ $status === 'expired' ? 'selected' : '' }}>Expired</option>
                            <option value="cancelled" {{ $status === 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                            <option value="suspended" {{ $status === 'suspended' ? 'selected' : '' }}>Suspended</option>
                        </select>
                    </div>
                </div>
            </div>
        </div>

        <!-- Subscriptions Table -->
        <div class="card border-0 shadow-sm">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                        <tr>
                            <th>User</th>
                            <th>Plan</th>
                            <th>Status</th>
                            <th>Start Date</th>
                            <th>End Date</th>
                            <th>Amount</th>
                            <th>Auto Renew</th>
                            <th>Actions</th>
                        </tr>
                        </thead>
                        <tbody>
                        @forelse($subscriptions as $subscription)
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="avatar-sm bg-primary bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center me-2">
                                            <i class="bi bi-person text-primary"></i>
                                        </div>
                                        <div>
                                            <div class="fw-semibold">{{ $subscription->user->first_name }} {{ $subscription->user->last_name }}</div>
                                            <small class="text-muted">{{ $subscription->user->email }}</small>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <span class="fw-semibold">{{ $subscription->plan->name }}</span><br>
                                    <small class="text-muted">{{ ucfirst($subscription->plan->duration) }}</small>
                                </td>
                                <td>
                                <span class="badge bg-{{ $subscription->status === 'active' ? 'success' : ($subscription->status === 'expired' ? 'warning' : 'secondary') }}">
                                    {{ ucfirst($subscription->status) }}
                                </span>
                                </td>
                                <td>{{ $subscription->start_date ? $subscription->start_date->format('M d, Y') : 'N/A' }}</td>
                                <td>{{ $subscription->end_date ? $subscription->end_date->format('M d, Y') : 'N/A' }}</td>
                                <td>{{ $subscription->plan->currency }} {{ number_format($subscription->plan->price, 2) }}</td>
                                <td>
                                    @if($subscription->auto_renew)
                                        <i class="bi bi-check-circle-fill text-success"></i>
                                    @else
                                        <i class="bi bi-x-circle-fill text-danger"></i>
                                    @endif
                                </td>
                                <td>
                                    <div class="btn-group">
                                        <a href="{{ route('admin.user-subscriptions.show', $subscription->id) }}" class="btn btn-sm btn-outline-primary">
                                            <i class="bi bi-eye"></i>
                                        </a>
                                        @if($subscription->status === 'active')
                                            <button class="btn btn-sm btn-outline-danger" onclick="cancelSubscription({{ $subscription->id }})">
                                                <i class="bi bi-x-circle"></i>
                                            </button>
                                        @elseif($subscription->status === 'cancelled')
                                            <button class="btn btn-sm btn-outline-success" onclick="activateSubscription({{ $subscription->id }})">
                                                <i class="bi bi-check-circle"></i>
                                            </button>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="text-center py-5">
                                    <i class="bi bi-inbox fs-1 text-muted d-block mb-3"></i>
                                    <p class="text-muted">No user subscriptions found</p>
                                </td>
                            </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>

                @if($subscriptions->hasPages())
                    <div class="mt-4">
                        {{ $subscriptions->links() }}
                    </div>
                @endif
            </div>
        </div>
    </div>

    <script>
        function cancelSubscription(id) {
            if (!confirm('Are you sure you want to cancel this subscription?')) return;

            fetch(`/admin/user-subscriptions/${id}/cancel`, {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'Content-Type': 'application/json',
                }
            })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        location.reload();
                    } else {
                        alert(data.message || 'Failed to cancel subscription');
                    }
                });
        }

        function activateSubscription(id) {
            if (!confirm('Are you sure you want to activate this subscription?')) return;

            fetch(`/admin/user-subscriptions/${id}/activate`, {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'Content-Type': 'application/json',
                }
            })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        location.reload();
                    } else {
                        alert(data.message || 'Failed to activate subscription');
                    }
                });
        }
    </script>
@endsection
