@extends('layouts.business')

@section('title', 'My Campaigns')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-6">
            <h1 class="h3 mb-0">My Marketing Campaigns</h1>
        </div>
        <div class="col-md-6 text-right">
            <a href="{{ route('business.marketing.index') }}" class="btn btn-primary">
                <i class="fas fa-plus"></i> Create New Campaign
            </a>
        </div>
    </div>

    <!-- Statistics -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card text-center">
                <div class="card-body">
                    <h3 class="mb-0">{{ $stats['total'] }}</h3>
                    <p class="text-muted mb-0">Total</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-center">
                <div class="card-body">
                    <h3 class="mb-0 text-success">{{ $stats['active'] }}</h3>
                    <p class="text-muted mb-0">Active</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-center">
                <div class="card-body">
                    <h3 class="mb-0 text-warning">{{ $stats['pending'] }}</h3>
                    <p class="text-muted mb-0">Pending</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-center">
                <div class="card-body">
                    <h3 class="mb-0 text-info">{{ $stats['completed'] }}</h3>
                    <p class="text-muted mb-0">Completed</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="GET" class="form-inline">
                <select name="status" class="form-control mr-2">
                    <option value="">All Status</option>
                    <option value="pending">Pending</option>
                    <option value="approved">Approved</option>
                    <option value="active">Active</option>
                    <option value="paused">Paused</option>
                    <option value="completed">Completed</option>
                    <option value="rejected">Rejected</option>
                </select>

                <select name="type" class="form-control mr-2">
                    <option value="">All Types</option>
                    <option value="banner">Banner</option>
                    <option value="featured_offer">Featured Offer</option>
                    <option value="featured_venue">Featured Venue</option>
                    <option value="popup">Popup</option>
                    <option value="spotlight_boost">Spotlight Boost</option>
                </select>

                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-filter"></i> Filter
                </button>
            </form>
        </div>
    </div>

    <!-- Campaigns Table -->
    <div class="card">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead>
                    <tr>
                        <th>Campaign</th>
                        <th>Type</th>
                        <th>Package</th>
                        <th>Duration</th>
                        <th>Performance</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($campaigns as $campaign)
                    <tr>
                        <td>
                            <strong>{{ $campaign->name }}</strong><br>
                            <small class="text-muted">Created {{ $campaign->created_at->diffForHumans() }}</small>
                        </td>
                        <td>
                            <span class="badge badge-info">{{ ucfirst(str_replace('_', ' ', $campaign->type)) }}</span>
                        </td>
                        <td>{{ $campaign->package->name }}</td>
                        <td>
                            {{ $campaign->start_date->format('M d') }} - {{ $campaign->end_date->format('M d, Y') }}
                        </td>
                        <td>
                            <small>
                                <i class="fas fa-eye"></i> {{ number_format($campaign->impressions) }}<br>
                                <i class="fas fa-mouse-pointer"></i> {{ number_format($campaign->clicks) }}
                                <span class="text-muted">({{ $campaign->ctr }}%)</span>
                            </small>
                        </td>
                        <td>
                            @if($campaign->status === 'active')
                                <span class="badge badge-success">Active</span>
                            @elseif($campaign->status === 'pending')
                                <span class="badge badge-warning">Pending</span>
                            @elseif($campaign->status === 'approved')
                                <span class="badge badge-info">Approved</span>
                            @elseif($campaign->status === 'paused')
                                <span class="badge badge-secondary">Paused</span>
                            @elseif($campaign->status === 'completed')
                                <span class="badge badge-dark">Completed</span>
                            @elseif($campaign->status === 'rejected')
                                <span class="badge badge-danger">Rejected</span>
                            @endif
                        </td>
                        <td>
                            <a href="{{ route('business.marketing.view', $campaign->id) }}" class="btn btn-sm btn-primary">
                                <i class="fas fa-eye"></i>
                            </a>

                            @if($campaign->status === 'active')
                            <button onclick="pauseCampaign({{ $campaign->id }})" class="btn btn-sm btn-warning">
                                <i class="fas fa-pause"></i>
                            </button>
                            @elseif($campaign->status === 'paused')
                            <button onclick="resumeCampaign({{ $campaign->id }})" class="btn btn-sm btn-success">
                                <i class="fas fa-play"></i>
                            </button>
                            @endif

                            @if($campaign->status === 'pending')
                            <button onclick="deleteCampaign({{ $campaign->id }})" class="btn btn-sm btn-danger">
                                <i class="fas fa-trash"></i>
                            </button>
                            @endif
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="7" class="text-center py-4">
                            <p class="text-muted mb-3">No campaigns yet</p>
                            <a href="{{ route('business.marketing.index') }}" class="btn btn-primary">
                                Create Your First Campaign
                            </a>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="mt-4">
        {{ $campaigns->links() }}
    </div>
</div>

<script>
function pauseCampaign(id) {
    if (confirm('Are you sure you want to pause this campaign?')) {
        fetch(`/business/marketing/campaigns/${id}/pause`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Accept': 'application/json',
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert(data.message);
            }
        });
    }
}

function resumeCampaign(id) {
    fetch(`/business/marketing/campaigns/${id}/resume`, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}',
            'Accept': 'application/json',
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        } else {
            alert(data.message);
        }
    });
}

function deleteCampaign(id) {
    if (confirm('Are you sure you want to delete this campaign?')) {
        fetch(`/business/marketing/campaigns/${id}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Accept': 'application/json',
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert(data.message);
            }
        });
    }
}
</script>
@endsection
