@extends('layouts.business')

@section('title', 'Notifications')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="fw-bold mb-1">Notifications</h2>
            <p class="text-muted mb-0">Stay updated with your business activities</p>
        </div>
        <div class="d-flex gap-2">
            <button class="btn btn-outline-primary" onclick="markAllAsRead()">
                <i class="bi bi-check-all me-2"></i>Mark All as Read
            </button>
            <a href="{{ route('business.notifications.preferences') }}" class="btn btn-outline-secondary">
                <i class="bi bi-gear me-2"></i>Preferences
            </a>
        </div>
    </div>

    <!-- Filter Tabs -->
    <ul class="nav nav-tabs mb-4">
        <li class="nav-item">
            <a class="nav-link {{ request('filter') !== 'read' ? 'active' : '' }}" href="{{ route('business.notifications.index') }}">
                <i class="bi bi-bell me-2"></i>All Notifications
                @if($counts['total'] > 0)
                    <span class="badge bg-primary ms-2">{{ $counts['total'] }}</span>
                @endif
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link" href="{{ route('business.notifications.index', ['filter' => 'unread']) }}">
                <i class="bi bi-bell-fill me-2"></i>Unread
                @if($counts['unread'] > 0)
                    <span class="badge bg-danger ms-2">{{ $counts['unread'] }}</span>
                @endif
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link {{ request('filter') === 'read' ? 'active' : '' }}" href="{{ route('business.notifications.index', ['filter' => 'read']) }}">
                <i class="bi bi-check-circle me-2"></i>Read
            </a>
        </li>
    </ul>

    <!-- Notification Types Filter -->
    <div class="mb-4">
        <div class="btn-group btn-group-sm" role="group">
            <a href="{{ route('business.notifications.index') }}" class="btn {{ !request('type') ? 'btn-primary' : 'btn-outline-primary' }}">
                All
            </a>
            <a href="{{ route('business.notifications.index', ['type' => 'redemption']) }}" class="btn {{ request('type') === 'redemption' ? 'btn-primary' : 'btn-outline-primary' }}">
                <i class="bi bi-qr-code me-1"></i>Redemptions
            </a>
            <a href="{{ route('business.notifications.index', ['type' => 'review']) }}" class="btn {{ request('type') === 'review' ? 'btn-primary' : 'btn-outline-primary' }}">
                <i class="bi bi-star me-1"></i>Reviews
            </a>
            <a href="{{ route('business.notifications.index', ['type' => 'team']) }}" class="btn {{ request('type') === 'team' ? 'btn-primary' : 'btn-outline-primary' }}">
                <i class="bi bi-people me-1"></i>Team
            </a>
            <a href="{{ route('business.notifications.index', ['type' => 'subscription']) }}" class="btn {{ request('type') === 'subscription' ? 'btn-primary' : 'btn-outline-primary' }}">
                <i class="bi bi-credit-card me-1"></i>Subscription
            </a>
            <a href="{{ route('business.notifications.index', ['type' => 'system']) }}" class="btn {{ request('type') === 'system' ? 'btn-primary' : 'btn-outline-primary' }}">
                <i class="bi bi-gear me-1"></i>System
            </a>
        </div>
    </div>

    <!-- Notifications List -->
    <div class="table-card">
        <div class="list-group list-group-flush">
            @forelse($notifications as $notification)
                @php
                    $notifData = is_array($notification->data) ? $notification->data : json_decode($notification->data, true) ?? [];
                @endphp
                <div class="list-group-item {{ $notification->read_at ? '' : 'bg-light border-start border-primary border-3' }}"
                     style="cursor: pointer;"
                     onclick="markAsRead('{{ $notification->id }}', '{{ $notifData['url'] ?? '#' }}')">
                    <div class="d-flex align-items-start">
                        <!-- Icon -->
                        <div class="me-3">
                            <div class="d-flex align-items-center justify-content-center rounded-circle"
                                 style="width: 48px; height: 48px; background: #e8eaf6;">
                                <i class="bi bi-bell fs-5" style="color: #667eea;"></i>
                            </div>
                        </div>

                        <!-- Content -->
                        <div class="flex-grow-1">
                            <div class="d-flex justify-content-between align-items-start mb-1">
                                <h6 class="mb-0 {{ $notification->read_at ? '' : 'fw-bold' }}">
                                    {{ $notifData['title'] ?? ucfirst(str_replace('_', ' ', $notification->type)) }}
                                </h6>
                                <small class="text-muted">{{ $notification->created_at->diffForHumans() }}</small>
                            </div>
                            <p class="mb-2 text-muted">{{ $notifData['message'] ?? 'No message' }}</p>

                            @if(isset($notifData['action']))
                                <a href="{{ $notifData['action']['url'] ?? '#' }}" class="btn btn-sm btn-outline-primary">
                                    {{ $notifData['action']['label'] ?? 'View' }}
                                </a>
                            @endif
                        </div>

                        <!-- Unread indicator -->
                        @if(!$notification->read_at)
                            <div class="ms-3">
                                <span class="badge bg-primary rounded-pill">New</span>
                            </div>
                        @endif
                    </div>
                </div>
            @empty
                <div class="list-group-item text-center py-5">
                    <i class="bi bi-bell-slash fs-1 text-muted d-block mb-3"></i>
                    <h5>No notifications</h5>
                    <p class="text-muted mb-0">You're all caught up!</p>
                </div>
            @endforelse
        </div>

        @if($notifications->hasPages())
            <div class="card-footer bg-white">
                {{ $notifications->links() }}
            </div>
        @endif
    </div>

    <!-- Notification Examples (for demo) -->
    <div class="mt-5">
        <h5 class="fw-bold mb-3">Notification Types</h5>
        <div class="row g-3">
            <div class="col-md-6">
                <div class="card border-0 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex align-items-start">
                            <div class="me-3">
                                <div class="d-flex align-items-center justify-content-center rounded-circle"
                                     style="width: 40px; height: 40px; background: rgba(67, 233, 123, 0.1);">
                                    <i class="bi bi-qr-code fs-5 text-success"></i>
                                </div>
                            </div>
                            <div>
                                <h6 class="mb-1">New Redemption</h6>
                                <small class="text-muted">When a customer redeems an offer</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="card border-0 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex align-items-start">
                            <div class="me-3">
                                <div class="d-flex align-items-center justify-content-center rounded-circle"
                                     style="width: 40px; height: 40px; background: rgba(255, 193, 7, 0.1);">
                                    <i class="bi bi-star fs-5 text-warning"></i>
                                </div>
                            </div>
                            <div>
                                <h6 class="mb-1">New Review</h6>
                                <small class="text-muted">When you receive a customer review</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="card border-0 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex align-items-start">
                            <div class="me-3">
                                <div class="d-flex align-items-center justify-content-center rounded-circle"
                                     style="width: 40px; height: 40px; background: rgba(102, 126, 234, 0.1);">
                                    <i class="bi bi-people fs-5 text-primary"></i>
                                </div>
                            </div>
                            <div>
                                <h6 class="mb-1">Team Activity</h6>
                                <small class="text-muted">Team member joins or performs actions</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="card border-0 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex align-items-start">
                            <div class="me-3">
                                <div class="d-flex align-items-center justify-content-center rounded-circle"
                                     style="width: 40px; height: 40px; background: rgba(240, 147, 251, 0.1);">
                                    <i class="bi bi-credit-card fs-5 text-danger"></i>
                                </div>
                            </div>
                            <div>
                                <h6 class="mb-1">Subscription Updates</h6>
                                <small class="text-muted">Billing and subscription renewals</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        function markAllAsRead() {
            if (confirm('Mark all notifications as read?')) {
                fetch('{{ route("business.notifications.mark-all-read") }}', {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}',
                        'Content-Type': 'application/json'
                    }
                })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            location.reload();
                        }
                    });
            }
        }

        function markAsRead(notificationId, url) {
            fetch(`/business/notifications/${notificationId}/read`, {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'Content-Type': 'application/json'
                }
            })
                .then(() => {
                    if (url && url !== '#') {
                        window.location.href = url;
                    } else {
                        location.reload();
                    }
                });
        }
    </script>
@endpush
