<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Invoice #{{ $invoice->id }}</title>
    <style>
        body { font-family: Arial, sans-serif; font-size: 14px; line-height: 1.6; }
        .header { margin-bottom: 30px; }
        .header h1 { margin: 0; font-size: 28px; }
        .info-row { display: flex; justify-content: space-between; margin-bottom: 30px; }
        table { width: 100%; border-collapse: collapse; margin: 20px 0; }
        th, td { padding: 12px; text-align: left; border-bottom: 1px solid #ddd; }
        th { background-color: #f8f9fa; font-weight: bold; }
        .text-end { text-align: right; }
        .total-row { font-weight: bold; font-size: 16px; }
        .badge { padding: 4px 8px; border-radius: 4px; font-size: 12px; }
        .badge-success { background-color: #28a745; color: white; }
        .badge-warning { background-color: #ffc107; color: black; }
        .badge-danger { background-color: #dc3545; color: white; }
        .footer { margin-top: 40px; padding-top: 20px; border-top: 1px solid #ddd; font-size: 12px; color: #666; }
    </style>
</head>
<body>
<div class="header">
    <table style="border: none;">
        <tr>
            <td style="border: none;">
                <h1>INVOICE</h1>
                <p>Invoice #{{ str_pad($invoice->id, 6, '0', STR_PAD_LEFT) }}</p>
            </td>
            <td style="border: none; text-align: right;">
                <h3>Privasee</h3>
                <p>Premium Offers Platform<br>Dubai, UAE</p>
            </td>
        </tr>
    </table>
</div>

<div class="info-row">
    <table style="border: none;">
        <tr>
            <td style="border: none; width: 50%;">
                <h4>Bill To:</h4>
                <p>
                    <strong>{{ $invoice->business->business_name ?? 'N/A' }}</strong><br>
                    {{ $invoice->business->address ?? '' }}<br>
                    {{ $invoice->business->city ?? '' }}
                </p>
            </td>
            <td style="border: none; text-align: right;">
                <h4>Invoice Details:</h4>
                <p>
                    <strong>Date:</strong> {{ $invoice->payment_date ? $invoice->payment_date->format('M d, Y') : now()->format('M d, Y') }}<br>
                    <strong>Status:</strong>
                    <span class="badge badge-{{ $invoice->status === 'completed' ? 'success' : ($invoice->status === 'pending' ? 'warning' : 'danger') }}">
                            {{ ucfirst($invoice->status) }}
                        </span>
                </p>
            </td>
        </tr>
    </table>
</div>

<table>
    <thead>
    <tr>
        <th>Description</th>
        <th class="text-end">Amount</th>
    </tr>
    </thead>
    <tbody>
    <tr>
        <td>
            <strong>{{ $invoice->subscription->plan->name ?? 'Subscription Plan' }}</strong><br>
            <small>{{ $invoice->description ?? 'Monthly Subscription' }}</small>
        </td>
        <td class="text-end">{{ $invoice->currency }} {{ number_format($invoice->amount, 2) }}</td>
    </tr>
    </tbody>
    <tfoot>
    <tr class="total-row">
        <td class="text-end">Total Amount:</td>
        <td class="text-end">{{ $invoice->currency }} {{ number_format($invoice->amount, 2) }}</td>
    </tr>
    </tfoot>
</table>

<div class="footer">
    <p>
        Transaction ID: {{ $invoice->transaction_id ?? 'N/A' }}<br>
        Payment Method: {{ ucfirst($invoice->payment_method) }}
    </p>
    <p>Thank you for your business!</p>
</div>
</body>
</html>
