@extends('layouts.business')

@section('title', 'Support Tickets')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="fw-bold mb-1">Support Tickets</h2>
        <p class="text-muted mb-0">View and manage your support requests</p>
    </div>
    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createTicketModal">
        <i class="bi bi-plus-lg me-2"></i>Create New Ticket
    </button>
</div>

<!-- Stats Cards -->
<div class="row g-4 mb-4">
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                <i class="bi bi-ticket-perforated text-white"></i>
            </div>
            <div class="stat-label">Total Tickets</div>
            <div class="stat-value">{{ $stats['total'] ?? 0 }}</div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon" style="background: linear-gradient(135deg, #fa709a 0%, #fee140 100%);">
                <i class="bi bi-clock-history text-white"></i>
            </div>
            <div class="stat-label">Open</div>
            <div class="stat-value">{{ $stats['open'] ?? 0 }}</div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon" style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);">
                <i class="bi bi-hourglass-split text-white"></i>
            </div>
            <div class="stat-label">In Progress</div>
            <div class="stat-value">{{ $stats['in_progress'] ?? 0 }}</div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon" style="background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);">
                <i class="bi bi-check-circle text-white"></i>
            </div>
            <div class="stat-label">Resolved</div>
            <div class="stat-value">{{ $stats['resolved'] ?? 0 }}</div>
        </div>
    </div>
</div>

<!-- Filters -->
<div class="mb-4">
    <div class="btn-group btn-group-sm" role="group">
        <a href="{{ route('business.support.tickets') }}" class="btn {{ !request('status') ? 'btn-primary' : 'btn-outline-primary' }}">
            All
        </a>
        <a href="{{ route('business.support.tickets', ['status' => 'open']) }}" class="btn {{ request('status') === 'open' ? 'btn-primary' : 'btn-outline-primary' }}">
            Open
        </a>
        <a href="{{ route('business.support.tickets', ['status' => 'in_progress']) }}" class="btn {{ request('status') === 'in_progress' ? 'btn-primary' : 'btn-outline-primary' }}">
            In Progress
        </a>
        <a href="{{ route('business.support.tickets', ['status' => 'resolved']) }}" class="btn {{ request('status') === 'resolved' ? 'btn-primary' : 'btn-outline-primary' }}">
            Resolved
        </a>
        <a href="{{ route('business.support.tickets', ['status' => 'closed']) }}" class="btn {{ request('status') === 'closed' ? 'btn-primary' : 'btn-outline-primary' }}">
            Closed
        </a>
    </div>
</div>

<!-- Tickets Table -->
<div class="table-card">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead>
                    <tr>
                        <th>Ticket ID</th>
                        <th>Subject</th>
                        <th>Category</th>
                        <th>Priority</th>
                        <th>Status</th>
                        <th>Created</th>
                        <th>Last Updated</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($tickets ?? [] as $ticket)
                    <tr>
                        <td class="font-monospace">#{{ $ticket->id }}</td>
                        <td>
                            <div class="fw-semibold">{{ $ticket->subject }}</div>
                            <small class="text-muted">{{ $ticket->replies_count ?? 0 }} replies</small>
                        </td>
                        <td>
                            <span class="badge bg-light text-dark">{{ $ticket->category }}</span>
                        </td>
                        <td>
                            @if($ticket->priority === 'high')
                                <span class="badge bg-danger">High</span>
                            @elseif($ticket->priority === 'medium')
                                <span class="badge bg-warning">Medium</span>
                            @else
                                <span class="badge bg-secondary">Low</span>
                            @endif
                        </td>
                        <td>
                            @if($ticket->status === 'open')
                                <span class="badge bg-warning">Open</span>
                            @elseif($ticket->status === 'in_progress')
                                <span class="badge bg-info">In Progress</span>
                            @elseif($ticket->status === 'resolved')
                                <span class="badge bg-success">Resolved</span>
                            @else
                                <span class="badge bg-secondary">Closed</span>
                            @endif
                        </td>
                        <td>{{ $ticket->created_at->format('M d, Y') }}</td>
                        <td>{{ $ticket->updated_at->diffForHumans() }}</td>
                        <td>
                            <a href="{{ route('business.support.ticket', $ticket->id) }}" class="btn btn-sm btn-outline-primary">
                                <i class="bi bi-eye"></i> View
                            </a>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="text-center py-5">
                            <i class="bi bi-ticket-perforated fs-1 text-muted d-block mb-3"></i>
                            <h5>No tickets found</h5>
                            <p class="text-muted">Create a ticket if you need help</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
{{--display validation errors--}}
@if ($errors->any())
    <div class="alert alert-danger mt-4">
        <ul class="mb-0">
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif
<!-- Create Ticket Modal -->
<div class="modal fade" id="createTicketModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form action="{{ route('business.support.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">Create Support Ticket</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Subject <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="subject" required placeholder="Brief description of your issue">
                    </div>

                    <div class="row g-3 mb-3">
                        <div class="col-md-6">
                            <label class="form-label">Category <span class="text-danger">*</span></label>
                            <select class="form-select" name="category" required>
                                <option value="">Select Category</option>
                                <option value="general">General Question</option>
                                <option value="technical">Technical Issue</option>
                                <option value="billing">Billing & Payments</option>
                                <option value="venues">Venue Management</option>
                                <option value="offers">Offer Management</option>
                                <option value="team">Team Management</option>
                                <option value="analytics">Analytics & Reports</option>
                                <option value="other">Other</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Priority <span class="text-danger">*</span></label>
                            <select class="form-select" name="priority" required>
                                <option value="low">Low - General inquiry</option>
                                <option value="medium" selected>Medium - Needs attention</option>
                                <option value="high">High - Critical issue</option>
                            </select>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Description <span class="text-danger">*</span></label>
                        <textarea class="form-control" name="description" rows="6" required placeholder="Please provide detailed information about your issue..."></textarea>
                        <small class="text-muted">The more details you provide, the faster we can help you</small>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Attachments</label>
                        <input type="file" class="form-control" name="attachments[]" multiple accept="image/*,.pdf,.doc,.docx">
                        <small class="text-muted">You can attach screenshots or documents (Max 5MB each)</small>
                    </div>

                    <div class="alert alert-info">
                        <i class="bi bi-info-circle me-2"></i>
                        <strong>Response Time:</strong> We typically respond within 24 hours during business days
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-send me-2"></i>Submit Ticket
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
