@extends('layouts.business')

@section('title', 'Team Management')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="fw-bold mb-1">Team Management</h2>
            <p class="text-muted mb-0">Manage your team members, roles and permissions</p>
        </div>
        @if(!isset($requires_subscription) && !isset($no_permission))
            <div class="d-flex gap-2">
                <button class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#manageRolesModal">
                    <i class="bi bi-shield-check me-2"></i>View Roles
                </button>
                <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#inviteModal">
                    <i class="bi bi-person-plus me-2"></i>Invite Team Member
                </button>
            </div>
        @endif
    </div>

    @if(isset($requires_subscription) && $requires_subscription)
        <!-- Subscription Required Alert -->
        <div class="alert alert-warning border-0 shadow-sm mb-4">
            <div class="row align-items-center">
                <div class="col-md-8">
                    <h5 class="alert-heading mb-2">
                        <i class="bi bi-lock-fill me-2"></i>Subscription Required
                    </h5>
                    <p class="mb-0">
                        Team management is a premium feature. Subscribe to a plan to invite and manage team members.
                    </p>
                </div>
                <div class="col-md-4 text-end">
                    <a href="{{ route('business.subscription.plans') }}" class="btn btn-warning">
                        <i class="bi bi-star-fill me-2"></i>View Plans
                    </a>
                </div>
            </div>
        </div>
    @endif

    @if(isset($no_permission) && $no_permission)
        <!-- No Permission Alert -->
        <div class="alert alert-danger border-0 shadow-sm mb-4">
            <div class="row align-items-center">
                <div class="col-md-12">
                    <h5 class="alert-heading mb-2">
                        <i class="bi bi-shield-x me-2"></i>Access Denied
                    </h5>
                    <p class="mb-0">
                        You do not have permission to manage team members. Please contact your business administrator.
                    </p>
                </div>
            </div>
        </div>
    @endif

    <!-- Stats Cards -->
    <div class="row g-4 mb-4">
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-icon" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                    <i class="bi bi-people text-white"></i>
                </div>
                <div class="stat-label">Total Members</div>
                <div class="stat-value">{{ $stats['total_staff'] ?? 0 }}</div>
                <small class="text-muted">{{ $stats['active_staff'] ?? 0 }} active</small>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-icon" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
                    <i class="bi bi-person-badge text-white"></i>
                </div>
                <div class="stat-label">Managers</div>
                <div class="stat-value">{{ $stats['managers'] ?? 0 }}</div>
                <small class="text-muted">Full access</small>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-icon" style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);">
                    <i class="bi bi-person text-white"></i>
                </div>
                <div class="stat-label">Staff Members</div>
                <div class="stat-value">{{ $stats['staff_members'] ?? 0 }}</div>
                <small class="text-muted">Limited access</small>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-icon" style="background: linear-gradient(135deg, #fa709a 0%, #fee140 100%);">
                    <i class="bi bi-envelope text-white"></i>
                </div>
                <div class="stat-label">Pending Invites</div>
                <div class="stat-value">{{ $stats['pending_invitations'] ?? 0 }}</div>
                <small class="text-muted">Awaiting response</small>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="table-card mb-4">
        <div class="card-body">
            <form method="GET" class="row g-3">
                <div class="col-md-3">
                    <input type="text" class="form-control" name="search" placeholder="Search by name or email" value="{{ request('search') }}">
                </div>
                <div class="col-md-2">
                    <select class="form-select" name="role">
                        <option value="">All Roles</option>
                        <option value="manager" {{ request('role') === 'manager' ? 'selected' : '' }}>Managers</option>
                        <option value="staff" {{ request('role') === 'staff' ? 'selected' : '' }}>Staff</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <select class="form-select" name="status">
                        <option value="">All Status</option>
                        <option value="active" {{ request('status') === 'active' ? 'selected' : '' }}>Active</option>
                        <option value="pending_invitation" {{ request('status') === 'pending_invitation' ? 'selected' : '' }}>Pending</option>
                        <option value="inactive" {{ request('status') === 'inactive' ? 'selected' : '' }}>Inactive</option>
                    </select>
                </div>
                <div class="col-md-5">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-search me-2"></i>Filter
                    </button>
                    <a href="{{ route('business.team.index') }}" class="btn btn-outline-secondary">
                        <i class="bi bi-x-lg me-2"></i>Clear
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Team Members Table -->
    <div class="table-card">
        <div class="card-header">
            <h5 class="mb-0 fw-bold">Team Members</h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                    <tr>
                        <th>Member</th>
                        <th>Role</th>
                        <th>Permissions</th>
                        <th>Status</th>
                        <th>Joined Date</th>
                        <th>Actions</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($staff as $member)
                        <tr>
                            <td>
                                <div class="d-flex align-items-center gap-3">
                                    <img src="https://ui-avatars.com/api/?name={{ $member->user->full_name }}&background=random"
                                         class="rounded-circle" width="40" height="40">
                                    <div>
                                        <div class="fw-semibold">{{ $member->user->full_name }}</div>
                                        <small class="text-muted">{{ $member->user->email }}</small>
                                    </div>
                                </div>
                            </td>
                            <td>
                                @if($member->role === 'owner')
                                    <span class="badge bg-gradient" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                                    <i class="bi bi-crown me-1"></i>Owner
                                </span>
                                @elseif($member->role === 'manager')
                                    <span class="badge bg-primary">
                                    <i class="bi bi-person-badge me-1"></i>Manager
                                </span>
                                @else
                                    <span class="badge bg-secondary">
                                    <i class="bi bi-person me-1"></i>Staff
                                </span>
                                @endif
                            </td>
                            <td>
                                @if($member->role === 'owner')
                                    <small class="text-muted">Full Access</small>
                                @else
                                    <div class="d-flex flex-wrap gap-1">
                                        @foreach($member->permissions ?? [] as $permission)
                                            <span class="badge bg-light text-dark">{{ str_replace('_', ' ', ucfirst($permission)) }}</span>
                                        @endforeach
                                    </div>
                                @endif
                            </td>
                            <td>
                                @if($member->status === 'active')
                                    <span class="badge bg-success">
                                    <i class="bi bi-check-circle me-1"></i>Active
                                </span>
                                @elseif($member->status === 'pending_invitation')
                                    <span class="badge bg-warning">
                                    <i class="bi bi-clock me-1"></i>Pending
                                </span>
                                @else
                                    <span class="badge bg-secondary">
                                    <i class="bi bi-dash-circle me-1"></i>Inactive
                                </span>
                                @endif
                            </td>
                            <td>
                                @if($member->joined_at)
                                    <span>{{ $member->joined_at->format('M d, Y') }}</span>
                                    <br><small class="text-muted">{{ $member->joined_at->diffForHumans() }}</small>
                                @else
                                    <span class="text-muted">Not joined</span>
                                    <br><small>Invited {{ $member->invited_at->diffForHumans() }}</small>
                                @endif
                            </td>
                            <td>
                                <div class="btn-group">
                                    @if($member->role !== 'owner')
                                        <button class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#editModal{{ $member->id }}">
                                            <i class="bi bi-pencil"></i>
                                        </button>
                                        @if($member->status === 'pending_invitation')
                                            <form action="{{ route('business.team.resend-invitation', $member->id) }}" method="POST" class="d-inline">
                                                @csrf
                                                <button type="submit" class="btn btn-sm btn-outline-info" title="Resend Invitation">
                                                    <i class="bi bi-send"></i>
                                                </button>
                                            </form>
                                        @endif
                                        <button class="btn btn-sm btn-outline-danger" data-bs-toggle="modal" data-bs-target="#deleteModal{{ $member->id }}">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    @else
                                        <span class="text-muted small">Owner</span>
                                    @endif
                                </div>
                            </td>
                        </tr>

                        <!-- Edit Modal -->
                        <div class="modal fade" id="editModal{{ $member->id }}" tabindex="-1">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <form action="{{ route('business.team.update', $member->id) }}" method="POST">
                                        @csrf
                                        @method('PUT')
                                        <div class="modal-header">
                                            <h5 class="modal-title">Edit Team Member</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                        </div>
                                        <div class="modal-body">
                                            <div class="mb-3">
                                                <label class="form-label">Role</label>
                                                <select class="form-select" name="role" required>
                                                    <option value="manager" {{ $member->role === 'manager' ? 'selected' : '' }}>Manager</option>
                                                    <option value="staff" {{ $member->role === 'staff' ? 'selected' : '' }}>Staff</option>
                                                </select>
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label">Permissions</label>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="permissions[]" value="manage_venues" id="perm1_{{ $member->id }}"
                                                        {{ in_array('manage_venues', $member->permissions ?? []) ? 'checked' : '' }}>
                                                    <label class="form-check-label" for="perm1_{{ $member->id }}">Manage Venues</label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="permissions[]" value="manage_offers" id="perm2_{{ $member->id }}"
                                                        {{ in_array('manage_offers', $member->permissions ?? []) ? 'checked' : '' }}>
                                                    <label class="form-check-label" for="perm2_{{ $member->id }}">Manage Offers</label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="permissions[]" value="manage_staff" id="perm3_{{ $member->id }}"
                                                        {{ in_array('manage_staff', $member->permissions ?? []) ? 'checked' : '' }}>
                                                    <label class="form-check-label" for="perm3_{{ $member->id }}">Manage Staff</label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="permissions[]" value="view_analytics" id="perm4_{{ $member->id }}"
                                                        {{ in_array('view_analytics', $member->permissions ?? []) ? 'checked' : '' }}>
                                                    <label class="form-check-label" for="perm4_{{ $member->id }}">View Analytics</label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="permissions[]" value="redeem_offers" id="perm5_{{ $member->id }}"
                                                        {{ in_array('redeem_offers', $member->permissions ?? []) ? 'checked' : '' }}>
                                                    <label class="form-check-label" for="perm5_{{ $member->id }}">Redeem Offers</label>
                                                </div>
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label">Status</label>
                                                <select class="form-select" name="status">
                                                    <option value="active" {{ $member->status === 'active' ? 'selected' : '' }}>Active</option>
                                                    <option value="inactive" {{ $member->status === 'inactive' ? 'selected' : '' }}>Inactive</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                            <button type="submit" class="btn btn-primary">Save Changes</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <!-- Delete Modal -->
                        <div class="modal fade" id="deleteModal{{ $member->id }}" tabindex="-1">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header border-0">
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                    </div>
                                    <div class="modal-body text-center py-4">
                                        <div class="mb-3">
                                            <i class="bi bi-exclamation-triangle text-danger" style="font-size: 4rem;"></i>
                                        </div>
                                        <h5>Remove Team Member?</h5>
                                        <p class="text-muted">Are you sure you want to remove <strong>{{ $member->user->full_name }}</strong> from your team?</p>
                                    </div>
                                    <div class="modal-footer border-0 justify-content-center">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                        <form action="{{ route('business.team.destroy', $member->id) }}" method="POST" class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger">Yes, Remove</button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @empty
                        <tr>
                            <td colspan="6" class="text-center py-5">
                                <i class="bi bi-people fs-1 text-muted d-block mb-3"></i>
                                <p class="text-muted mb-0">No team members found</p>
                            </td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
        </div>
{{--        @if($staff->hasPages())--}}
{{--            <div class="card-footer bg-white">--}}
{{--                {{ $staff->links() }}--}}
{{--            </div>--}}
{{--        @endif--}}
    </div>

    <!-- Invite Modal -->
    <div class="modal fade" id="inviteModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form action="{{ route('business.team.store') }}" method="POST">
                    @csrf
                    <div class="modal-header">
                        <h5 class="modal-title">Invite Team Member</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">Email Address</label>
                            <input type="email" class="form-control" name="email" required placeholder="member@example.com">
                            <small class="text-muted">An invitation will be sent to this email</small>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Role</label>
                            <select class="form-select" name="role" id="roleSelect" required onchange="toggleCustomPermissions()">
                                <optgroup label="System Roles">
                                    <option value="manager">Manager - Full management access</option>
                                    <option value="staff">Staff - Custom permissions</option>
                                </optgroup>
                                @if(isset($customRoles) && count($customRoles) > 0)
                                    <optgroup label="Custom Roles">
                                        @foreach($customRoles as $role)
                                            <option value="custom_{{ $role->id }}">{{ $role->name }}</option>
                                        @endforeach
                                    </optgroup>
                                @endif
                            </select>
{{--                            <small class="text-muted">--}}
{{--                                Don't see the role you need?--}}
{{--                                <a href="#" data-bs-toggle="modal" data-bs-target="#manageRolesModal" data-bs-dismiss="modal">Create custom role</a>--}}
{{--                            </small>--}}
                        </div>
                        <div class="mb-3" id="customPermissionsSection">
                            <label class="form-label">Custom Permissions</label>
                            <div class="alert alert-info small mb-2">
                                <i class="bi bi-info-circle me-1"></i>
                                Only shown when "Staff" role is selected. Custom roles have predefined permissions.
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="permissions[]" value="manage_venues" id="newPerm1">
                                <label class="form-check-label" for="newPerm1">Manage Venues</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="permissions[]" value="manage_offers" id="newPerm2">
                                <label class="form-check-label" for="newPerm2">Manage Offers</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="permissions[]" value="manage_staff" id="newPerm3">
                                <label class="form-check-label" for="newPerm3">Manage Staff</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="permissions[]" value="view_analytics" id="newPerm4">
                                <label class="form-check-label" for="newPerm4">View Analytics</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="permissions[]" value="redeem_offers" id="newPerm5" checked>
                                <label class="form-check-label" for="newPerm5">Redeem Offers</label>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-send me-2"></i>Send Invitation
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Manage Roles Modal -->
    <div class="modal fade" id="manageRolesModal" tabindex="-1">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Manage Custom Roles</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
{{--                    <div class="d-flex justify-content-between align-items-center mb-4">--}}
{{--                        <p class="text-muted mb-0">Create and manage custom roles for your team members</p>--}}
{{--                        <button class="btn btn-sm btn-primary" onclick="showCreateRoleForm()">--}}
{{--                            <i class="bi bi-plus-lg me-1"></i>Create New Role--}}
{{--                        </button>--}}
{{--                    </div>--}}

                    <!-- Create Role Form (Hidden by default) -->
{{--                    <div id="createRoleForm" class="card border-primary mb-4" style="display: none;">--}}
{{--                        <div class="card-header bg-primary text-white">--}}
{{--                            <h6 class="mb-0">Create New Role</h6>--}}
{{--                        </div>--}}
{{--                        <div class="card-body">--}}
{{--                            <form action="{{ route('business.roles.store') }}" method="POST">--}}
{{--                                @csrf--}}
{{--                                <div class="row g-3">--}}
{{--                                    <div class="col-md-6">--}}
{{--                                        <label class="form-label">Role Name <span class="text-danger">*</span></label>--}}
{{--                                        <input type="text" class="form-control" name="role_name" required placeholder="e.g., Shift Manager, Cashier">--}}
{{--                                    </div>--}}
{{--                                    <div class="col-md-6">--}}
{{--                                        <label class="form-label">Display Color</label>--}}
{{--                                        <select class="form-select" name="role_color">--}}
{{--                                            <option value="primary">Blue</option>--}}
{{--                                            <option value="success">Green</option>--}}
{{--                                            <option value="warning">Orange</option>--}}
{{--                                            <option value="info">Cyan</option>--}}
{{--                                            <option value="secondary">Gray</option>--}}
{{--                                        </select>--}}
{{--                                    </div>--}}
{{--                                    <div class="col-12">--}}
{{--                                        <label class="form-label">Description</label>--}}
{{--                                        <textarea class="form-control" name="description" rows="2" placeholder="Brief description of this role"></textarea>--}}
{{--                                    </div>--}}

{{--                                    <div class="col-12">--}}
{{--                                        <label class="form-label fw-semibold mb-3">Permissions</label>--}}
{{--                                        <div class="row g-3">--}}
{{--                                            <!-- Venue Permissions -->--}}
{{--                                            <div class="col-md-6">--}}
{{--                                                <div class="card bg-light">--}}
{{--                                                    <div class="card-body">--}}
{{--                                                        <h6 class="fw-bold mb-3">--}}
{{--                                                            <i class="bi bi-geo-alt text-primary me-2"></i>Venue Management--}}
{{--                                                        </h6>--}}
{{--                                                        <div class="form-check mb-2">--}}
{{--                                                            <input class="form-check-input" type="checkbox" name="permissions[]" value="view_venues" id="perm_view_venues">--}}
{{--                                                            <label class="form-check-label" for="perm_view_venues">View Venues</label>--}}
{{--                                                        </div>--}}
{{--                                                        <div class="form-check mb-2">--}}
{{--                                                            <input class="form-check-input" type="checkbox" name="permissions[]" value="create_venues" id="perm_create_venues">--}}
{{--                                                            <label class="form-check-label" for="perm_create_venues">Create Venues</label>--}}
{{--                                                        </div>--}}
{{--                                                        <div class="form-check mb-2">--}}
{{--                                                            <input class="form-check-input" type="checkbox" name="permissions[]" value="edit_venues" id="perm_edit_venues">--}}
{{--                                                            <label class="form-check-label" for="perm_edit_venues">Edit Venues</label>--}}
{{--                                                        </div>--}}
{{--                                                        <div class="form-check">--}}
{{--                                                            <input class="form-check-input" type="checkbox" name="permissions[]" value="delete_venues" id="perm_delete_venues">--}}
{{--                                                            <label class="form-check-label" for="perm_delete_venues">Delete Venues</label>--}}
{{--                                                        </div>--}}
{{--                                                    </div>--}}
{{--                                                </div>--}}
{{--                                            </div>--}}

{{--                                            <!-- Offer Permissions -->--}}
{{--                                            <div class="col-md-6">--}}
{{--                                                <div class="card bg-light">--}}
{{--                                                    <div class="card-body">--}}
{{--                                                        <h6 class="fw-bold mb-3">--}}
{{--                                                            <i class="bi bi-tag text-success me-2"></i>Offer Management--}}
{{--                                                        </h6>--}}
{{--                                                        <div class="form-check mb-2">--}}
{{--                                                            <input class="form-check-input" type="checkbox" name="permissions[]" value="view_offers" id="perm_view_offers">--}}
{{--                                                            <label class="form-check-label" for="perm_view_offers">View Offers</label>--}}
{{--                                                        </div>--}}
{{--                                                        <div class="form-check mb-2">--}}
{{--                                                            <input class="form-check-input" type="checkbox" name="permissions[]" value="create_offers" id="perm_create_offers">--}}
{{--                                                            <label class="form-check-label" for="perm_create_offers">Create Offers</label>--}}
{{--                                                        </div>--}}
{{--                                                        <div class="form-check mb-2">--}}
{{--                                                            <input class="form-check-input" type="checkbox" name="permissions[]" value="edit_offers" id="perm_edit_offers">--}}
{{--                                                            <label class="form-check-label" for="perm_edit_offers">Edit Offers</label>--}}
{{--                                                        </div>--}}
{{--                                                        <div class="form-check">--}}
{{--                                                            <input class="form-check-input" type="checkbox" name="permissions[]" value="delete_offers" id="perm_delete_offers">--}}
{{--                                                            <label class="form-check-label" for="perm_delete_offers">Delete Offers</label>--}}
{{--                                                        </div>--}}
{{--                                                    </div>--}}
{{--                                                </div>--}}
{{--                                            </div>--}}

{{--                                            <!-- Redemption Permissions -->--}}
{{--                                            <div class="col-md-6">--}}
{{--                                                <div class="card bg-light">--}}
{{--                                                    <div class="card-body">--}}
{{--                                                        <h6 class="fw-bold mb-3">--}}
{{--                                                            <i class="bi bi-qr-code text-warning me-2"></i>Redemptions--}}
{{--                                                        </h6>--}}
{{--                                                        <div class="form-check mb-2">--}}
{{--                                                            <input class="form-check-input" type="checkbox" name="permissions[]" value="view_redemptions" id="perm_view_redemptions">--}}
{{--                                                            <label class="form-check-label" for="perm_view_redemptions">View Redemptions</label>--}}
{{--                                                        </div>--}}
{{--                                                        <div class="form-check mb-2">--}}
{{--                                                            <input class="form-check-input" type="checkbox" name="permissions[]" value="redeem_offers" id="perm_redeem_offers">--}}
{{--                                                            <label class="form-check-label" for="perm_redeem_offers">Redeem Offers</label>--}}
{{--                                                        </div>--}}
{{--                                                        <div class="form-check">--}}
{{--                                                            <input class="form-check-input" type="checkbox" name="permissions[]" value="manage_redemptions" id="perm_manage_redemptions">--}}
{{--                                                            <label class="form-check-label" for="perm_manage_redemptions">Manage Redemptions</label>--}}
{{--                                                        </div>--}}
{{--                                                    </div>--}}
{{--                                                </div>--}}
{{--                                            </div>--}}

{{--                                            <!-- Team Permissions -->--}}
{{--                                            <div class="col-md-6">--}}
{{--                                                <div class="card bg-light">--}}
{{--                                                    <div class="card-body">--}}
{{--                                                        <h6 class="fw-bold mb-3">--}}
{{--                                                            <i class="bi bi-people text-info me-2"></i>Team Management--}}
{{--                                                        </h6>--}}
{{--                                                        <div class="form-check mb-2">--}}
{{--                                                            <input class="form-check-input" type="checkbox" name="permissions[]" value="view_team" id="perm_view_team">--}}
{{--                                                            <label class="form-check-label" for="perm_view_team">View Team</label>--}}
{{--                                                        </div>--}}
{{--                                                        <div class="form-check mb-2">--}}
{{--                                                            <input class="form-check-input" type="checkbox" name="permissions[]" value="invite_team" id="perm_invite_team">--}}
{{--                                                            <label class="form-check-label" for="perm_invite_team">Invite Members</label>--}}
{{--                                                        </div>--}}
{{--                                                        <div class="form-check mb-2">--}}
{{--                                                            <input class="form-check-input" type="checkbox" name="permissions[]" value="edit_team" id="perm_edit_team">--}}
{{--                                                            <label class="form-check-label" for="perm_edit_team">Edit Members</label>--}}
{{--                                                        </div>--}}
{{--                                                        <div class="form-check">--}}
{{--                                                            <input class="form-check-input" type="checkbox" name="permissions[]" value="remove_team" id="perm_remove_team">--}}
{{--                                                            <label class="form-check-label" for="perm_remove_team">Remove Members</label>--}}
{{--                                                        </div>--}}
{{--                                                    </div>--}}
{{--                                                </div>--}}
{{--                                            </div>--}}

{{--                                            <!-- Analytics Permissions -->--}}
{{--                                            <div class="col-md-6">--}}
{{--                                                <div class="card bg-light">--}}
{{--                                                    <div class="card-body">--}}
{{--                                                        <h6 class="fw-bold mb-3">--}}
{{--                                                            <i class="bi bi-graph-up text-danger me-2"></i>Analytics & Reports--}}
{{--                                                        </h6>--}}
{{--                                                        <div class="form-check mb-2">--}}
{{--                                                            <input class="form-check-input" type="checkbox" name="permissions[]" value="view_analytics" id="perm_view_analytics">--}}
{{--                                                            <label class="form-check-label" for="perm_view_analytics">View Analytics</label>--}}
{{--                                                        </div>--}}
{{--                                                        <div class="form-check mb-2">--}}
{{--                                                            <input class="form-check-input" type="checkbox" name="permissions[]" value="export_reports" id="perm_export_reports">--}}
{{--                                                            <label class="form-check-label" for="perm_export_reports">Export Reports</label>--}}
{{--                                                        </div>--}}
{{--                                                        <div class="form-check">--}}
{{--                                                            <input class="form-check-input" type="checkbox" name="permissions[]" value="view_financial" id="perm_view_financial">--}}
{{--                                                            <label class="form-check-label" for="perm_view_financial">View Financial Data</label>--}}
{{--                                                        </div>--}}
{{--                                                    </div>--}}
{{--                                                </div>--}}
{{--                                            </div>--}}

{{--                                            <!-- Settings Permissions -->--}}
{{--                                            <div class="col-md-6">--}}
{{--                                                <div class="card bg-light">--}}
{{--                                                    <div class="card-body">--}}
{{--                                                        <h6 class="fw-bold mb-3">--}}
{{--                                                            <i class="bi bi-gear text-secondary me-2"></i>Settings--}}
{{--                                                        </h6>--}}
{{--                                                        <div class="form-check mb-2">--}}
{{--                                                            <input class="form-check-input" type="checkbox" name="permissions[]" value="view_settings" id="perm_view_settings">--}}
{{--                                                            <label class="form-check-label" for="perm_view_settings">View Settings</label>--}}
{{--                                                        </div>--}}
{{--                                                        <div class="form-check mb-2">--}}
{{--                                                            <input class="form-check-input" type="checkbox" name="permissions[]" value="edit_business_profile" id="perm_edit_profile">--}}
{{--                                                            <label class="form-check-label" for="perm_edit_profile">Edit Business Profile</label>--}}
{{--                                                        </div>--}}
{{--                                                        <div class="form-check">--}}
{{--                                                            <input class="form-check-input" type="checkbox" name="permissions[]" value="manage_subscription" id="perm_manage_sub">--}}
{{--                                                            <label class="form-check-label" for="perm_manage_sub">Manage Subscription</label>--}}
{{--                                                        </div>--}}
{{--                                                    </div>--}}
{{--                                                </div>--}}
{{--                                            </div>--}}
{{--                                        </div>--}}
{{--                                    </div>--}}
{{--                                </div>--}}

{{--                                <div class="d-flex gap-2 justify-content-end mt-3">--}}
{{--                                    <button type="button" class="btn btn-secondary" onclick="hideCreateRoleForm()">Cancel</button>--}}
{{--                                    <button type="submit" class="btn btn-primary">--}}
{{--                                        <i class="bi bi-check-lg me-1"></i>Create Role--}}
{{--                                    </button>--}}
{{--                                </div>--}}
{{--                            </form>--}}
{{--                        </div>--}}
{{--                    </div>--}}

                    <!-- Existing Roles List -->
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                            <tr>
                                <th>Role Name</th>
                                <th>Description</th>
                                <th>Permissions</th>
                                <th>Members</th>
                                <th>Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                            <!-- System Roles (Cannot be edited) -->
                            <tr class="table-light">
                                <td>
                                    <span class="badge" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                                        <i class="bi bi-crown me-1"></i>Owner
                                    </span>
                                </td>
                                <td>Business owner with full access</td>
                                <td><span class="badge bg-success">All Permissions</span></td>
                                <td>1</td>
                                <td><span class="text-muted small">System Role</span></td>
                            </tr>
                            <tr class="table-light">
                                <td><span class="badge bg-primary">Manager</span></td>
                                <td>Full management access</td>
                                <td><span class="badge bg-success">All Permissions</span></td>
                                <td>{{ $stats['managers'] ?? 0 }}</td>
                                <td><span class="text-muted small">System Role</span></td>
                            </tr>
                            <tr class="table-light">
                                <td><span class="badge bg-secondary">Staff</span></td>
                                <td>Basic staff member</td>
                                <td><span class="badge bg-info">Custom Permissions</span></td>
                                <td>{{ $stats['staff_members'] ?? 0 }}</td>
                                <td><span class="text-muted small">System Role</span></td>
                            </tr>

                            <!-- Custom Roles -->
                            @forelse($customRoles ?? [] as $role)
                                <tr>
                                    <td>
                                    <span class="badge bg-{{ $role->color ?? 'secondary' }}">
                                        <i class="bi bi-person-badge me-1"></i>{{ $role->name }}
                                    </span>
                                    </td>
                                    <td>{{ $role->description ?? 'Custom role' }}</td>
                                    <td>
                                        <span class="badge bg-light text-dark">{{ count($role->permissions ?? []) }} permissions</span>
                                    </td>
                                    <td>{{ $role->members_count ?? 0 }}</td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <button class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#editRoleModal{{ $role->id }}">
                                                <i class="bi bi-pencil"></i>
                                            </button>
                                            <button class="btn btn-outline-danger" data-bs-toggle="modal" data-bs-target="#deleteRoleModal{{ $role->id }}">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="text-center py-4 text-muted">
                                        <i class="bi bi-shield-check fs-3 d-block mb-2"></i>
                                        No custom roles created yet. Click "Create New Role" to get started.
                                    </td>
                                </tr>
                            @endforelse
                            </tbody>
                        </table>
                    </div>

{{--                    <div class="alert alert-info d-flex align-items-start mt-4">--}}
{{--                        <i class="bi bi-info-circle me-2 mt-1"></i>--}}
{{--                        <div>--}}
{{--                            <strong>About Custom Roles:</strong>--}}
{{--                            <ul class="mb-0 mt-2">--}}
{{--                                <li>Custom roles help you organize your team with specific permissions</li>--}}
{{--                                <li>System roles (Owner, Manager, Staff) cannot be modified or deleted</li>--}}
{{--                                <li>You can create unlimited custom roles for your business needs</li>--}}
{{--                                <li>Team members can only have one role at a time</li>--}}
{{--                            </ul>--}}
{{--                        </div>--}}
{{--                    </div>--}}
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        function showCreateRoleForm() {
            document.getElementById('createRoleForm').style.display = 'block';
            document.getElementById('createRoleForm').scrollIntoView({ behavior: 'smooth' });
        }

        function hideCreateRoleForm() {
            document.getElementById('createRoleForm').style.display = 'none';
        }

        function toggleCustomPermissions() {
            const roleSelect = document.getElementById('roleSelect');
            const permissionsSection = document.getElementById('customPermissionsSection');

            if (roleSelect.value === 'staff') {
                // Show custom permissions for Staff role
                permissionsSection.style.display = 'block';
            } else {
                // Hide for Manager and Custom roles
                permissionsSection.style.display = 'none';
            }
        }

        // Initialize on page load
        document.addEventListener('DOMContentLoaded', function() {
            toggleCustomPermissions();
        });
    </script>
@endpush
