<?php $__env->startSection('title', __('Accept Invitation')); ?>
<?php $__env->startSection('content'); ?>

<?php if($errors->any()): ?>
    <div class="alert alert-danger">
        <ul>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
<?php endif; ?>
    <div class="container mx-auto px-4">
        <div class="max-w-md mx-auto bg-white p-6 rounded-lg shadow-md">
            <h2 class="text-2xl font-semibold mb-4"><?php echo e(__('Accept Invitation')); ?></h2>
            <form method="POST" action="<?php echo e(route('business.team.accept-invitation', $invitation->id)); ?>">
                <?php echo csrf_field(); ?>
                <div class="mb-4">
                    <label for="name" class="block text-gray-700"><?php echo e(__('First Name')); ?></label>
                    <input type="text" id="first_name" name="first_name" value="<?php echo e(old('first_name', $invitation->user->first_name)); ?>" required
                           class="w-full px-3 py-2 border rounded-lg focus:outline-none focus:ring focus:border-blue-300">
                </div>
                <div class="mb-4">
                    <label for="name" class="block text-gray-700"><?php echo e(__('Last Name')); ?></label>
                    <input type="text" id="last_name" name="last_name" value="<?php echo e(old('last_name')); ?>" required
                           class="w-full px-3 py-2 border rounded-lg focus:outline-none focus:ring focus:border-blue-300">
                </div>
                <div class="mb-4">
                    <label for="password" class="block text-gray-700"><?php echo e(__('Password')); ?></label>
                    <input type="password" id="password" name="password" required
                           class="w-full px-3 py-2 border rounded-lg focus:outline-none focus:ring focus:border-blue-300">
                </div>
                <div class="mb-4">
                    <label for="password_confirmation" class="block text-gray-700"><?php echo e(__('Confirm Password')); ?></label>
                    <input type="password" id="password_confirmation" name="password_confirmation" required
                           class="w-full px-3 py-2 border rounded-lg focus:outline-none focus:ring focus:border-blue-300">
                </div>
                <button type="submit"
                        class="w-full bg-blue-500 text-white py-2 px-4 rounded-lg hover:bg-blue-600 transition duration-200">
                    <?php echo e(__('Accept Invitation')); ?>

                </button>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.guest', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/business/team/accept-invitation.blade.php ENDPATH**/ ?>