<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', 'Admin Panel'); ?> - Privasee</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">

    <link rel="icon" type="image/svg+xml" href="<?php echo e(asset('favicon.svg')); ?>">
    <style>
        :root {
            --admin-primary: #1a73e8;
            --admin-secondary: #34a853;
            --admin-danger: #ea4335;
            --admin-warning: #fbbc04;
            --admin-dark: #1f2937;
            --admin-light: #f8f9fa;
        }

        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            background: #f5f6fa;
            overflow-x: hidden;
        }

        .admin-sidebar {
            position: fixed;
            top: 0;
            left: 0;
            height: 100vh;
            width: 260px;
            background: linear-gradient(180deg, #1f2937 0%, #111827 100%);
            padding: 0;
            transition: all 0.3s;
            z-index: 1000;
            overflow-y: auto;
        }

        .admin-sidebar::-webkit-scrollbar {
            width: 5px;
        }

        .admin-sidebar::-webkit-scrollbar-thumb {
            background: rgba(255,255,255,0.2);
            border-radius: 10px;
        }

        .sidebar-header {
            padding: 24px 20px;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }

        .sidebar-brand {
            color: white;
            font-size: 24px;
            font-weight: 700;
            text-decoration: none;
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .sidebar-brand i {
            width: 40px;
            height: 40px;
            background: linear-gradient(135deg, var(--admin-primary), var(--admin-secondary));
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 20px;
        }

        .sidebar-menu {
            padding: 20px 0;
        }

        .menu-section {
            padding: 0 20px;
            margin-bottom: 24px;
        }

        .menu-section-title {
            color: rgba(255,255,255,0.5);
            font-size: 11px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 12px;
        }

        .menu-item {
            display: flex;
            align-items: center;
            padding: 12px 16px;
            color: rgba(255,255,255,0.8);
            text-decoration: none;
            border-radius: 8px;
            margin-bottom: 4px;
            transition: all 0.2s;
            position: relative;
        }

        .menu-item:hover {
            background: rgba(255,255,255,0.1);
            color: white;
            transform: translateX(4px);
        }

        .menu-item.active {
            background: var(--admin-primary);
            color: white;
        }

        .menu-item i {
            width: 20px;
            margin-right: 12px;
            font-size: 18px;
        }

        .menu-item .badge {
            margin-left: auto;
            font-size: 10px;
            padding: 3px 8px;
        }

        .admin-main {
            margin-left: 260px;
            min-height: 100vh;
            transition: all 0.3s;
        }

        .admin-header {
            background: white;
            padding: 16px 32px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
            position: sticky;
            top: 0;
            z-index: 100;
        }

        .admin-header-inner {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .header-search {
            position: relative;
            width: 400px;
        }

        .header-search input {
            width: 100%;
            padding: 10px 40px 10px 16px;
            border: 1px solid #e5e7eb;
            border-radius: 8px;
            font-size: 14px;
        }

        .header-search i {
            position: absolute;
            right: 14px;
            top: 50%;
            transform: translateY(-50%);
            color: #9ca3af;
        }

        .header-actions {
            display: flex;
            align-items: center;
            gap: 16px;
        }

        .header-icon-btn {
            width: 40px;
            height: 40px;
            border: none;
            background: #f3f4f6;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #6b7280;
            cursor: pointer;
            position: relative;
            transition: all 0.2s;
        }

        .header-icon-btn:hover {
            background: #e5e7eb;
            color: var(--admin-primary);
        }

        .header-icon-btn .badge {
            position: absolute;
            top: -4px;
            right: -4px;
            width: 18px;
            height: 18px;
            border-radius: 50%;
            background: var(--admin-danger);
            color: white;
            font-size: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .admin-user-menu {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 8px 12px;
            background: #f9fafb;
            border-radius: 10px;
            cursor: pointer;
            transition: all 0.2s;
        }

        .admin-user-menu:hover {
            background: #e5e7eb;
        }

        .admin-user-avatar {
            width: 36px;
            height: 36px;
            border-radius: 8px;
            object-fit: cover;
        }

        .admin-user-info h6 {
            margin: 0;
            font-size: 14px;
            font-weight: 600;
            color: var(--admin-dark);
        }

        .admin-user-info p {
            margin: 0;
            font-size: 12px;
            color: #6b7280;
        }

        .admin-content {
            padding: 32px;
        }

        .stat-card {
            background: white;
            border-radius: 12px;
            padding: 24px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
            transition: all 0.3s;
            border: 1px solid #f3f4f6;
        }

        .stat-card:hover {
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
            transform: translateY(-2px);
        }

        .stat-icon {
            width: 56px;
            height: 56px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            margin-bottom: 16px;
        }

        .stat-label {
            color: #6b7280;
            font-size: 14px;
            font-weight: 500;
            margin-bottom: 8px;
        }

        .stat-value {
            font-size: 32px;
            font-weight: 700;
            color: var(--admin-dark);
            margin-bottom: 8px;
        }

        .stat-change {
            font-size: 13px;
            display: flex;
            align-items: center;
            gap: 4px;
        }

        .stat-change.positive {
            color: var(--admin-secondary);
        }

        .stat-change.negative {
            color: var(--admin-danger);
        }

        .admin-card {
            background: white;
            border-radius: 12px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
            border: 1px solid #f3f4f6;
        }

        .admin-card-header {
            padding: 20px 24px;
            border-bottom: 1px solid #f3f4f6;
        }

        .admin-card-body {
            padding: 24px;
        }

        .table-actions {
            display: flex;
            gap: 8px;
        }

        .btn-icon {
            width: 32px;
            height: 32px;
            padding: 0;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 6px;
        }

        @media (max-width: 768px) {
            .admin-sidebar {
                transform: translateX(-100%);
            }

            .admin-sidebar.mobile-open {
                transform: translateX(0);
            }

            .admin-main {
                margin-left: 0;
            }

            .header-search {
                display: none;
            }
        }

        .loading-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.5);
            display: none;
            align-items: center;
            justify-content: center;
            z-index: 9999;
        }

        .loading-overlay.show {
            display: flex;
        }

        .spinner {
            width: 50px;
            height: 50px;
            border: 4px solid rgba(255,255,255,0.3);
            border-top-color: white;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            to { transform: rotate(360deg); }
        }
    </style>
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body>
<!-- Sidebar -->
<div class="admin-sidebar">
    <div class="sidebar-header">
        <a href="<?php echo e(route('admin.dashboard')); ?>" class="sidebar-brand">
            <img src="<?php echo e(asset('logo/Privasee-logo-white-admin.svg')); ?>" alt="Privasee" style="height:60px;">
        </a>
    </div>

    <div class="sidebar-menu">
        <div class="menu-section">
            <div class="menu-section-title">Main</div>
            <?php if (\Illuminate\Support\Facades\Blade::check('haspermission', 'view-dashboard')): ?>
            <a href="<?php echo e(route('admin.dashboard')); ?>" class="menu-item <?php echo e(request()->routeIs('admin.dashboard') ? 'active' : ''); ?>">
                <i class="bi bi-speedometer2"></i>
                <span>Dashboard</span>
            </a>
            <?php endif; ?>

            <?php if (\Illuminate\Support\Facades\Blade::check('haspermission', 'view-analytics')): ?>
            <a href="<?php echo e(route('admin.analytics')); ?>" class="menu-item <?php echo e(request()->routeIs('admin.analytics') ? 'active' : ''); ?>">
                <i class="bi bi-graph-up"></i>
                <span>Analytics</span>
            </a>
            <?php endif; ?>
        </div>

        <div class="menu-section">
            <div class="menu-section-title">Management</div>
            <?php if (\Illuminate\Support\Facades\Blade::check('haspermission', 'manage-users')): ?>
            <a href="<?php echo e(route('admin.users.index')); ?>" class="menu-item <?php echo e(request()->routeIs('admin.users.*') ? 'active' : ''); ?>">
                <i class="bi bi-people"></i>
                <span>Users</span>
            </a>
            <?php endif; ?>

            <?php if (\Illuminate\Support\Facades\Blade::check('haspermission', 'manage-businesses')): ?>
            <a href="<?php echo e(route('admin.businesses.index')); ?>" class="menu-item <?php echo e(request()->routeIs('admin.businesses.*') ? 'active' : ''); ?>">
                <i class="bi bi-building"></i>
                <span>Businesses</span>
                <?php if(isset($pending_verifications) && $pending_verifications > 0): ?>
                    <span class="badge bg-danger"><?php echo e($pending_verifications); ?></span>
                <?php endif; ?>
            </a>
            <?php endif; ?>

            <?php if (\Illuminate\Support\Facades\Blade::check('haspermission', 'manage-venues')): ?>
            <a href="<?php echo e(route('admin.venues.index')); ?>" class="menu-item <?php echo e(request()->routeIs('admin.venues.*') ? 'active' : ''); ?>">
                <i class="bi bi-geo-alt"></i>
                <span>Venues</span>
            </a>
            <?php endif; ?>

            <?php if (\Illuminate\Support\Facades\Blade::check('haspermission', 'manage-offers')): ?>
            <a href="<?php echo e(route('admin.offers.index')); ?>" class="menu-item <?php echo e(request()->routeIs('admin.offers.*') ? 'active' : ''); ?>">
                <i class="bi bi-tag"></i>
                <span>Offers</span>
            </a>
            <?php endif; ?>

            <?php if (\Illuminate\Support\Facades\Blade::check('haspermission', 'manage-categories')): ?>
            <a href="<?php echo e(route('admin.categories.index')); ?>" class="menu-item <?php echo e(request()->routeIs('admin.categories.*') ? 'active' : ''); ?>">
                <i class="bi bi-grid"></i>
                <span>Categories</span>
            </a>
            <?php endif; ?>
        </div>

        <div class="menu-section">
            <div class="menu-section-title">Content</div>
            <?php if (\Illuminate\Support\Facades\Blade::check('haspermission', 'manage-reviews')): ?>
            <a href="<?php echo e(route('admin.reviews.index')); ?>" class="menu-item <?php echo e(request()->routeIs('admin.reviews.*') ? 'active' : ''); ?>">
                <i class="bi bi-star"></i>
                <span>Reviews</span>
            </a>
            <?php endif; ?>

            <?php if (\Illuminate\Support\Facades\Blade::check('haspermission', 'manage-spotlight')): ?>
            <a href="<?php echo e(route('admin.spotlight.index')); ?>" class="menu-item <?php echo e(request()->routeIs('admin.spotlight.*') ? 'active' : ''); ?>">
                <i class="bi bi-camera"></i>
                <span>Spotlight Posts</span>
            </a>
            <?php endif; ?>

            <?php if (\Illuminate\Support\Facades\Blade::check('haspermission', 'manage-moderation')): ?>
            <a href="<?php echo e(route('admin.moderation.index')); ?>" class="menu-item <?php echo e(request()->routeIs('admin.moderation.*') ? 'active' : ''); ?>">
                <i class="bi bi-shield-exclamation"></i>
                <span>Moderation</span>
                <?php if(isset($flagged_content) && $flagged_content > 0): ?>
                    <span class="badge bg-warning"><?php echo e($flagged_content); ?></span>
                <?php endif; ?>
            </a>
            <?php endif; ?>
        </div>

        <div class="menu-section">
            <div class="menu-section-title">Financial</div>
            <?php if (\Illuminate\Support\Facades\Blade::check('haspermission', 'manage-subscription-plans')): ?>
            <a href="<?php echo e(route('admin.subscription-plans.index')); ?>" class="menu-item <?php echo e(request()->routeIs('admin.subscription-plans.*') ? 'active' : ''); ?>">
                <i class="bi bi-box-seam"></i>
                <span>Subscription Plans</span>
            </a>
            <?php endif; ?>

            <?php if (\Illuminate\Support\Facades\Blade::check('haspermission', 'view-user-subscriptions')): ?>
            <a href="<?php echo e(route('admin.user-subscriptions.index')); ?>" class="menu-item <?php echo e(request()->routeIs('admin.user-subscriptions.*') ? 'active' : ''); ?>">
                <i class="bi bi-person-check"></i>
                <span>User Subscriptions</span>
            </a>
            <?php endif; ?>

            <?php if (\Illuminate\Support\Facades\Blade::check('haspermission', 'view-business-subscriptions')): ?>
            <a href="<?php echo e(route('admin.subscriptions.index')); ?>" class="menu-item <?php echo e(request()->routeIs('admin.subscriptions.*') ? 'active' : ''); ?>">
                <i class="bi bi-credit-card"></i>
                <span>Business Subscriptions</span>
            </a>
            <?php endif; ?>

            <?php if (\Illuminate\Support\Facades\Blade::check('haspermission', 'view-payments')): ?>
            <a href="<?php echo e(route('admin.payments.index')); ?>" class="menu-item <?php echo e(request()->routeIs('admin.payments.*') ? 'active' : ''); ?>">
                <i class="bi bi-wallet2"></i>
                <span>Payments</span>
            </a>
            <?php endif; ?>

            <?php if (\Illuminate\Support\Facades\Blade::check('haspermission', 'view-reports')): ?>
            <a href="<?php echo e(route('admin.reports.index')); ?>" class="menu-item <?php echo e(request()->routeIs('admin.reports.*') ? 'active' : ''); ?>">
                <i class="bi bi-file-earmark-text"></i>
                <span>Reports</span>
            </a>
            <?php endif; ?>
        </div>

        <div class="menu-section">
            <div class="menu-section-title">Marketing</div>
            <?php if (\Illuminate\Support\Facades\Blade::check('haspermission', 'manage-marketing')): ?>
            <a href="<?php echo e(route('admin.marketing.index')); ?>" class="menu-item <?php echo e(request()->routeIs('admin.marketing.*') ? 'active' : ''); ?>">
                <i class="bi bi-megaphone"></i>
                <span>Campaigns</span>
            </a>
            <?php endif; ?>
        </div>

        <div class="menu-section">
            <div class="menu-section-title">Support</div>
            <?php if (\Illuminate\Support\Facades\Blade::check('haspermission', 'manage-support-tickets')): ?>
            <a href="<?php echo e(route('admin.tickets.index')); ?>" class="menu-item <?php echo e(request()->routeIs('admin.tickets.*') ? 'active' : ''); ?>">
                <i class="bi bi-ticket-perforated"></i>
                <span>Support Tickets</span>
            </a>
            <?php endif; ?>

            <?php if (\Illuminate\Support\Facades\Blade::check('haspermission', 'manage-notifications')): ?>
            <a href="<?php echo e(route('admin.notifications.index')); ?>" class="menu-item <?php echo e(request()->routeIs('admin.notifications.*') ? 'active' : ''); ?>">
                <i class="bi bi-bell"></i>
                <span>Notifications</span>
            </a>
            <?php endif; ?>
        </div>

        <div class="menu-section">
            <div class="menu-section-title">System</div>
            <?php if (\Illuminate\Support\Facades\Blade::check('haspermission', 'manage-configuration')): ?>
            <a href="<?php echo e(route('admin.configuration.index')); ?>" class="menu-item <?php echo e(request()->routeIs('admin.configuration.*') ? 'active' : ''); ?>">
                <i class="bi bi-sliders"></i>
                <span>Configuration</span>
            </a>
            <?php endif; ?>

            <?php if (\Illuminate\Support\Facades\Blade::check('haspermission', 'manage-roles')): ?>
            <a href="<?php echo e(route('admin.roles.index')); ?>" class="menu-item <?php echo e(request()->routeIs('admin.roles.*') ? 'active' : ''); ?>">
                <i class="bi bi-shield-lock"></i>
                <span>Roles & Permissions</span>
            </a>
            <?php endif; ?>

            <?php if (\Illuminate\Support\Facades\Blade::check('haspermission', 'manage-settings')): ?>
            <a href="<?php echo e(route('admin.settings.index')); ?>" class="menu-item <?php echo e(request()->routeIs('admin.settings.*') ? 'active' : ''); ?>">
                <i class="bi bi-gear"></i>
                <span>Settings</span>
            </a>
            <?php endif; ?>

            <?php if (\Illuminate\Support\Facades\Blade::check('haspermission', 'view-audit-logs')): ?>
            <a href="<?php echo e(route('admin.audit-logs.index')); ?>" class="menu-item <?php echo e(request()->routeIs('admin.audit-logs.*') ? 'active' : ''); ?>">
                <i class="bi bi-journal-text"></i>
                <span>Audit Logs</span>
            </a>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Main Content -->
<div class="admin-main">
    <!-- Header -->
    <div class="admin-header">
        <div class="admin-header-inner">
            <div class="header-search">
                <input type="text" placeholder="Search users, businesses, offers...">
                <i class="bi bi-search"></i>
            </div>

            <div class="header-actions">
                <a href="<?php echo e(route('admin.notifications.index')); ?>" class="header-icon-btn">
                    <i class="bi bi-bell"></i>
                    <?php if(auth()->user()->unreadNotifications->count() > 0): ?>
                        <span class="badge"><?php echo e(auth()->user()->unreadNotifications->count()); ?></span>
                    <?php endif; ?>
                </a>

                <a href="<?php echo e(route('admin.tickets.index')); ?>" class="header-icon-btn">
                    <i class="bi bi-envelope"></i>
                    <?php
                        $pendingTickets = \App\Models\SupportTicket::where('status', 'pending')->count();
                    ?>
                    <?php if($pendingTickets > 0): ?>
                        <span class="badge"><?php echo e($pendingTickets); ?></span>
                    <?php endif; ?>
                </a>

                <div class="dropdown">
                    <div class="admin-user-menu" data-bs-toggle="dropdown">
                        <img src="https://ui-avatars.com/api/?name=Admin&background=1a73e8&color=fff"
                             alt="Admin" class="admin-user-avatar">
                        <div class="admin-user-info">
                            <h6>Admin User</h6>
                            <p>Super Admin</p>
                        </div>
                        <i class="bi bi-chevron-down"></i>
                    </div>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item" href="#"><i class="bi bi-person me-2"></i>Profile</a></li>
                        <li><a class="dropdown-item" href="#"><i class="bi bi-gear me-2"></i>Settings</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <form action="<?php echo e(route('admin.logout')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="dropdown-item text-danger">
                                    <i class="bi bi-box-arrow-right me-2"></i>Logout
                                </button>
                            </form>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <!-- Page Content -->
    <div class="admin-content">
        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="bi bi-check-circle me-2"></i><?php echo e(session('success')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="bi bi-exclamation-triangle me-2"></i><?php echo e(session('error')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <?php echo $__env->yieldContent('content'); ?>
    </div>
</div>

<!-- Loading Overlay -->
<div class="loading-overlay" id="loadingOverlay">
    <div class="spinner"></div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    function showLoading() {
        document.getElementById('loadingOverlay').classList.add('show');
    }

    function hideLoading() {
        document.getElementById('loadingOverlay').classList.remove('show');
    }

    function toggleNotifications() {
        alert('Notifications feature coming soon!');
    }

    function toggleMessages() {
        alert('Messages feature coming soon!');
    }
</script>
<?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>
<?php /**PATH C:\laragon\www\privasee\resources\views/layouts/admin.blade.php ENDPATH**/ ?>