


<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e(__('Team Invitation')); ?></title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 600px;
            margin: 20px auto;
            background-color: #ffffff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .header h1 {
            color: #333333;
        }
        .content {
            font-size: 16px;
            color: #555555;
        }
        .button {
            display: inline-block;
            padding: 10px 20px;
            margin-top: 20px;
            background-color: #007BFF;
            color: #ffffff;
            text-decoration: none;
            border-radius: 5px;
        }
        .button:hover {
            background-color: #0056b3;
        }
        .footer {
            margin-top: 30px;
            font-size: 12px;
            color: #999999;
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1><?php echo e(__('You are invited to join the team!')); ?></h1>
        </div>
        <div class="content">
            <p><?php echo e(__('Hello :name,', ['name' => $invitation->user->first_name])); ?></p>
            <p><?php echo e(__('You have been invited to join the team ":team" on our platform.', ['team' => $invitation->business->business_name])); ?></p>
            <p><?php echo e(__('To accept the invitation, please click the button below:')); ?></p>
            <a href="<?php echo e(route('business.team.accept-invitation',  $invitation->id)); ?>" class="button"><?php echo e(__('Accept Invitation')); ?></a>
            <p><?php echo e(__('If you did not expect this invitation, you can safely ignore this email.')); ?></p>
        </div>
        <div class="footer">
            <p><?php echo e(__('© :year Your Company. All rights reserved.', ['year' => date('Y')])); ?></p>
        </div>
    </div>

</body>
</html>
<?php /**PATH C:\laragon\www\privasee\resources\views/emails/team/invitation.blade.php ENDPATH**/ ?>