<?php $__env->startSection('title', 'Subscription Management'); ?>

<?php $__env->startSection('content'); ?>
    <div class="mb-4">
        <h2 class="fw-bold mb-1">Subscription Management</h2>
        <p class="text-muted mb-0">Manage your subscription plan and billing</p>
    </div>

    <?php if(!$subscription): ?>
        <!-- No Subscription - Show Plans -->
        <div class="row justify-content-center mb-4">
            <div class="col-lg-10">
                <div class="card border-0 shadow-sm text-center py-5">
                    <div class="card-body">
                        <div class="mb-4">
                            <i class="bi bi-box-seam" style="font-size: 4rem; color: #667eea;"></i>
                        </div>
                        <h3 class="fw-bold mb-3">No Active Subscription</h3>
                        <p class="text-muted mb-4">
                            You don't have an active subscription. Choose a plan to unlock powerful features for your business.
                        </p>
                        <a href="<?php echo e(route('business.subscription.plans')); ?>" class="btn btn-primary btn-lg">
                            <i class="bi bi-star me-2"></i>View Available Plans
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Feature Highlights -->
        <div class="row g-4 mb-4">
            <div class="col-md-4">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-body text-center p-4">
                        <div class="mb-3">
                            <i class="bi bi-building" style="font-size: 2.5rem; color: #667eea;"></i>
                        </div>
                        <h5 class="fw-bold mb-2">Multiple Venues</h5>
                        <p class="text-muted mb-0">Manage multiple locations and venues from one dashboard</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-body text-center p-4">
                        <div class="mb-3">
                            <i class="bi bi-ticket-perforated" style="font-size: 2.5rem; color: #764ba2;"></i>
                        </div>
                        <h5 class="fw-bold mb-2">Unlimited Offers</h5>
                        <p class="text-muted mb-0">Create and manage offers to attract more customers</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-body text-center p-4">
                        <div class="mb-3">
                            <i class="bi bi-people" style="font-size: 2.5rem; color: #667eea;"></i>
                        </div>
                        <h5 class="fw-bold mb-2">Team Collaboration</h5>
                        <p class="text-muted mb-0">Invite team members and manage permissions</p>
                    </div>
                </div>
            </div>
        </div>
    <?php else: ?>
        <!-- Current Plan Card -->
        <div class="row g-4 mb-4">
            <div class="col-lg-8">
                <div class="card border-0 shadow-sm" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                    <div class="card-body text-white p-4">
                        <div class="d-flex justify-content-between align-items-start mb-4">
                            <div>
                                <h3 class="fw-bold mb-2"><?php echo e($subscription->plan->name ?? 'Free Plan'); ?></h3>
                                <p class="mb-0 opacity-75"><?php echo e($subscription->plan->description ?? 'Basic features for small businesses'); ?></p>
                            </div>
                            <?php if($subscription->status === 'active'): ?>
                                <span class="badge bg-white text-primary px-3 py-2">
                            <i class="bi bi-check-circle me-1"></i>Active
                        </span>
                            <?php endif; ?>
                        </div>

                        <div class="row g-3">
                            <div class="col-md-4">
                                <div class="opacity-75 small">Current Period</div>
                                <div class="fs-5 fw-bold">
                                    <?php echo e($subscription->start_date ? $subscription->start_date->format('M d') : 'N/A'); ?> -
                                    <?php echo e($subscription->end_date ? $subscription->end_date->format('M d, Y') : 'N/A'); ?>

                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="opacity-75 small">Price</div>
                                <div class="fs-5 fw-bold">
                                    AED <?php echo e(number_format($subscription->plan->price ?? 0)); ?>/<?php echo e($subscription->plan->interval ?? 'month'); ?>

                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="opacity-75 small">Next Billing</div>
                                <div class="fs-5 fw-bold">
                                    <?php echo e($subscription->end_date ? $subscription->end_date->format('M d, Y') : 'N/A'); ?>

                                </div>
                            </div>
                        </div>

                        <div class="mt-4 pt-3 border-top border-white border-opacity-25">
                            <div class="d-flex gap-2">
                                <a href="<?php echo e(route('business.subscription.plans')); ?>" class="btn btn-light">
                                    <i class="bi bi-arrow-up-circle me-2"></i>Upgrade Plan
                                </a>
                                <button class="btn btn-outline-light" data-bs-toggle="modal" data-bs-target="#cancelModal">
                                    <i class="bi bi-x-circle me-2"></i>Cancel Subscription
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="table-card h-100">
                    <div class="card-body">
                        <h6 class="fw-bold mb-3">Usage Statistics</h6>

                        <div class="mb-3">
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <span class="small">Venues</span>
                                <span class="fw-semibold"><?php echo e($usage['venues'] ?? 0); ?> / <?php echo e($subscription->plan->max_venues ?? '∞'); ?></span>
                            </div>
                            <div class="progress" style="height: 8px;">
                                <div class="progress-bar bg-primary" style="width: <?php echo e($usage['venues_percentage'] ?? 0); ?>%"></div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <span class="small">Offers</span>
                                <span class="fw-semibold"><?php echo e($usage['offers'] ?? 0); ?> / <?php echo e($subscription->plan->max_offers ?? '∞'); ?></span>
                            </div>
                            <div class="progress" style="height: 8px;">
                                <div class="progress-bar bg-success" style="width: <?php echo e($usage['offers_percentage'] ?? 0); ?>%"></div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <span class="small">Team Members</span>
                                <span class="fw-semibold"><?php echo e($usage['staff'] ?? 0); ?> / <?php echo e($subscription->plan->max_staff ?? '∞'); ?></span>
                            </div>
                            <div class="progress" style="height: 8px;">
                                <div class="progress-bar bg-warning" style="width: <?php echo e($usage['staff_percentage'] ?? 0); ?>%"></div>
                            </div>
                        </div>

                        <div class="alert alert-info small mt-3">
                            <i class="bi bi-info-circle me-1"></i>
                            Upgrade your plan to increase limits
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Plan Features -->
        <div class="table-card mb-4">
            <div class="card-header">
                <h5 class="mb-0 fw-bold">Your Plan Features</h5>
            </div>
            <div class="card-body">
                <div class="row g-3">
                    <?php
                        $features = $subscription->plan->features ?? [];
                        if (is_string($features)) {
                            $features = json_decode($features, true) ?? [];
                        }
                    ?>
                    <?php $__empty_1 = true; $__currentLoopData = $features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="col-md-6">
                            <div class="d-flex align-items-start">
                                <i class="bi bi-check-circle-fill text-success me-2 mt-1"></i>
                                <span><?php echo e(is_array($feature) ? ($feature['name'] ?? $feature[0] ?? 'Feature') : $feature); ?></span>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="col-12">
                            <p class="text-muted mb-0">No features listed</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Billing History -->
        <div class="table-card mb-4">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0 fw-bold">Billing History</h5>
                <button class="btn btn-sm btn-outline-primary" onclick="downloadInvoice('all')">
                    <i class="bi bi-download me-1"></i>Download All
                </button>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead>
                        <tr>
                            <th>Invoice #</th>
                            <th>Date</th>
                            <th>Description</th>
                            <th>Amount</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $invoices ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td class="font-monospace">#<?php echo e($invoice->invoice_number); ?></td>
                                <td><?php echo e($invoice->created_at->format('M d, Y')); ?></td>
                                <td><?php echo e($invoice->description); ?></td>
                                <td class="fw-semibold">AED <?php echo e(number_format($invoice->amount, 2)); ?></td>
                                <td>
                                    <?php if($invoice->status === 'completed'): ?>
                                        <span class="badge bg-success">Paid</span>
                                    <?php elseif($invoice->status === 'pending'): ?>
                                        <span class="badge bg-warning">Pending</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">Failed</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm">
                                        <button class="btn btn-outline-primary" onclick="viewInvoice('<?php echo e($invoice->id); ?>')">
                                            <i class="bi bi-eye"></i>
                                        </button>
                                        <button class="btn btn-outline-primary" onclick="downloadInvoice('<?php echo e($invoice->id); ?>')">
                                            <i class="bi bi-download"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6" class="text-center py-4 text-muted">
                                    No billing history available yet
                                </td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Payment Method -->
        <div class="table-card">
            <div class="card-header">
                <h5 class="mb-0 fw-bold">Payment Method</h5>
            </div>
            <div class="card-body">
                <?php if($paymentMethod ?? false): ?>
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="d-flex align-items-center">
                            <i class="bi bi-credit-card fs-2 text-primary me-3"></i>
                            <div>
                                <div class="fw-semibold"><?php echo e($paymentMethod->brand ?? 'Card'); ?> ending in <?php echo e($paymentMethod->last4 ?? '****'); ?></div>
                                <small class="text-muted">Expires <?php echo e($paymentMethod->exp_month ?? '**'); ?>/<?php echo e($paymentMethod->exp_year ?? '**'); ?></small>
                            </div>
                        </div>
                        <button class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#updatePaymentModal">
                            <i class="bi bi-pencil me-2"></i>Update
                        </button>
                    </div>
                <?php else: ?>
                    <div class="text-center py-4">
                        <i class="bi bi-credit-card fs-1 text-muted d-block mb-3"></i>
                        <p class="text-muted mb-3">No payment method on file</p>
                        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#updatePaymentModal">
                            <i class="bi bi-plus-lg me-2"></i>Add Payment Method
                        </button>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Cancel Subscription Modal -->
        <div class="modal fade" id="cancelModal" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header border-0">
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body text-center py-4">
                        <i class="bi bi-exclamation-triangle text-warning" style="font-size: 4rem;"></i>
                        <h5 class="mt-3">Cancel Subscription?</h5>
                        <p class="text-muted">Your subscription will remain active until <?php echo e($subscription->current_period_end ? $subscription->current_period_end->format('M d, Y') : 'the end of the billing period'); ?></p>
                        <p class="text-danger small">You'll lose access to premium features after cancellation</p>

                        <div class="mt-4">
                            <p class="fw-semibold mb-3">Help us improve! Why are you canceling?</p>
                            <form action="<?php echo e(route('business.subscription.cancel')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <select class="form-select mb-3" name="reason">
                                    <option value="">Select a reason...</option>
                                    <option value="too_expensive">Too expensive</option>
                                    <option value="not_using">Not using enough</option>
                                    <option value="missing_features">Missing features</option>
                                    <option value="switching">Switching to competitor</option>
                                    <option value="other">Other</option>
                                </select>
                                <textarea class="form-control mb-3" name="feedback" rows="3" placeholder="Additional feedback (optional)"></textarea>

                                <div class="d-flex gap-2 justify-content-center">
                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Keep Subscription</button>
                                    <button type="submit" class="btn btn-danger">Yes, Cancel</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Update Payment Method Modal -->
        <div class="modal fade" id="updatePaymentModal" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Update Payment Method</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <form action="<?php echo e(route('business.subscription.update-payment')); ?>" method="POST" id="payment-form">
                            <?php echo csrf_field(); ?>
                            <div class="mb-3">
                                <label class="form-label">Card Number</label>
                                <input type="text" class="form-control" placeholder="1234 5678 9012 3456" maxlength="19">
                            </div>
                            <div class="row g-3 mb-3">
                                <div class="col-6">
                                    <label class="form-label">Expiry Date</label>
                                    <input type="text" class="form-control" placeholder="MM/YY" maxlength="5">
                                </div>
                                <div class="col-6">
                                    <label class="form-label">CVV</label>
                                    <input type="text" class="form-control" placeholder="123" maxlength="4">
                                </div>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Cardholder Name</label>
                                <input type="text" class="form-control" placeholder="John Doe">
                            </div>
                            <div class="alert alert-info small">
                                <i class="bi bi-shield-check me-1"></i>
                                Your payment information is encrypted and secure
                            </div>
                        </form>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" form="payment-form" class="btn btn-primary">Save Payment Method</button>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        function viewInvoice(invoiceId) {
            window.open(`/business/subscription/invoice/${invoiceId}`, '_blank');
        }

        function downloadInvoice(invoiceId) {
            window.location.href = `/business/subscription/invoice/${invoiceId}/download`;
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.business', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/business/subscription/index.blade.php ENDPATH**/ ?>